/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.core.configuration.DefaultBrandManager;
import org.eclipse.vtp.desktop.editors.core.controller.BasicController;
import org.eclipse.vtp.desktop.editors.core.controller.ControllerListener;
import org.eclipse.vtp.desktop.editors.core.impl.DialogEditor;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvas;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.editors.core.model.SelectionStructure;
import org.eclipse.vtp.desktop.editors.core.model.UICanvas;
import org.eclipse.vtp.desktop.editors.core.theme.CanvasFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ThemeManager;
import org.eclipse.vtp.desktop.views.pallet.Pallet;

public class DialogCustomizerWindow
extends Window
implements ControllerListener,
IAdaptable {
    private Pallet pallet = new Pallet();
    Map resourceMap = new HashMap();
    RenderedModel renderedModel = null;
    BasicController controller = null;
    Canvas canvas = null;
    CanvasFrame canvasFrame = null;
    boolean dirty = false;
    BrandManager brandManager = new DefaultBrandManager();
    Composite propertiesComp;
    Composite propertiesArea = null;
    IAdaptable adaptableContainer = null;

    public DialogCustomizerWindow(Shell parentShell) {
        super(parentShell);
    }

    public DialogCustomizerWindow(IShellProvider shellProvider) {
        super(shellProvider);
    }

    public void init(RenderedModel renderedModel) throws PartInitException {
        this.renderedModel = renderedModel;
        this.brandManager = renderedModel.getUIModel().getModel().getBrandManager();
        this.controller = new BasicController(this.brandManager, (RenderedCanvas)renderedModel.listRenderedCanvases().get(0));
        this.controller.setContainer(this);
        this.controller.setResourceMap(this.resourceMap);
        this.canvasFrame = ThemeManager.getDefault().getDefaultTheme().createCanvasFrame((UICanvas)renderedModel.getUIModel().listUICanvases().get(0));
    }

    public void setContainer(IAdaptable adaptableContainer) {
        this.adaptableContainer = adaptableContainer;
    }

    protected Control createContents(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ArrayList values = new ArrayList();
                values.addAll(DialogCustomizerWindow.this.resourceMap.values());
                int i = 0;
                while (i < values.size()) {
                    if (values.get(i) instanceof Resource) {
                        ((Resource)values.get(i)).dispose();
                    }
                    ++i;
                }
                DialogCustomizerWindow.this.resourceMap.clear();
            }
        });
        GC gc = new GC((Drawable)parent);
        this.renderedModel.initializeGraphics(gc, this.resourceMap);
        gc.dispose();
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginWidth = 4;
        fillLayout.marginHeight = 4;
        parent.setLayout((Layout)fillLayout);
        SashForm leftRight = new SashForm(parent, 256);
        Composite palComp = new Composite((Composite)leftRight, 0);
        palComp.setLayout((Layout)new FillLayout());
        CTabFolder tabs = new CTabFolder(palComp, 0x800880);
        tabs.setSimple(false);
        tabs.setTabHeight(22);
        CTabItem palletItem = new CTabItem(tabs, 0);
        palletItem.setText("Pallet");
        System.out.println(palletItem.getFont());
        palletItem.setImage(Activator.getDefault().getImageRegistry().get("ICON_LIBRARY"));
        this.pallet.setContainer((IAdaptable)this);
        this.pallet.createControl((Composite)tabs);
        palletItem.setControl(this.pallet.getControl());
        tabs.setSelection(0);
        this.pallet.getControl().setFocus();
        ScrolledComposite sc = new ScrolledComposite((Composite)leftRight, 2816);
        final Composite canvasFrameComp = new Composite((Composite)sc, 0x20040000);
        sc.setContent((Control)canvasFrameComp);
        canvasFrameComp.setLayout((Layout)new FormLayout());
        canvasFrameComp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                DialogCustomizerWindow.this.canvasFrame.setBounds(canvasFrameComp.getBounds());
            }
        });
        canvasFrameComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                HashMap resourceMap = new HashMap();
                DialogCustomizerWindow.this.canvasFrame.renderFrame(e.gc, 0, 0, resourceMap);
            }
        });
        RenderedCanvas rc = (RenderedCanvas)this.renderedModel.listRenderedCanvases().get(0);
        sc.setMinSize(rc.getUICanvas().getWidth() + this.canvasFrame.getInsets().x + this.canvasFrame.getInsets().width, rc.getUICanvas().getHeight() + this.canvasFrame.getInsets().y + this.canvasFrame.getInsets().height);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        this.canvas = new Canvas(canvasFrameComp, 0x20000000);
        this.canvas.setBackground(parent.getDisplay().getSystemColor(1));
        FormData fd = new FormData();
        fd.left = new FormAttachment(50, -1 * rc.getUICanvas().getWidth() / 2);
        fd.top = new FormAttachment(50, -1 * rc.getUICanvas().getHeight() / 2);
        fd.right = new FormAttachment(50, rc.getUICanvas().getWidth() / 2);
        fd.bottom = new FormAttachment(50, rc.getUICanvas().getHeight() / 2);
        this.canvas.setLayoutData((Object)fd);
        this.controller.setControl((Control)this.canvas);
        this.canvas.addPaintListener((PaintListener)this.controller);
        this.canvas.addMouseListener((MouseListener)this.controller);
        this.canvas.addMouseMoveListener((MouseMoveListener)this.controller);
        this.canvas.addMouseTrackListener((MouseTrackListener)this.controller);
        this.canvas.addKeyListener((KeyListener)this.controller);
        this.controller.addListener(this);
        this.hookContextMenu();
        leftRight.setWeights(new int[]{20, 80});
        return leftRight;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DialogCustomizerWindow.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        this.controller.fillContextMenu(manager);
    }

    public void graphicUpdate(int x, int y, int width, int height, boolean inProgress) {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.redraw(x, y, width, height, false);
        }
    }

    public void renderedModelChanged(RenderedModel renderedModel) {
    }

    public void selectionChanged(SelectionStructure selection) {
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(this.getClass())) {
            return this;
        }
        if (adapter.equals(DialogEditor.class)) {
            return new DialogEditor();
        }
        return null;
    }
}

