/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.core.configuration.DefaultBrandManager;
import org.eclipse.vtp.desktop.editors.core.controller.BasicController;
import org.eclipse.vtp.desktop.editors.core.controller.ControllerListener;
import org.eclipse.vtp.desktop.editors.core.impl.StubMediaProvider;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvas;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModelListener;
import org.eclipse.vtp.desktop.editors.core.model.SelectionStructure;
import org.eclipse.vtp.desktop.editors.core.model.UICanvas;
import org.eclipse.vtp.desktop.editors.core.model.UIModel;
import org.eclipse.vtp.desktop.editors.core.theme.CanvasFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ThemeManager;
import org.eclipse.vtp.desktop.model.core.Model;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.util.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DialogEditor
extends EditorPart
implements ControllerListener,
RenderedModelListener {
    RenderedModel renderedModel = null;
    BasicController controller = null;
    Canvas canvas = null;
    CanvasFrame canvasFrame = null;
    boolean dirty = false;
    DefaultBrandManager brandManager = new DefaultBrandManager();
    Map resourceMap = new HashMap();

    public DialogEditor() {
        this.brandManager.addInteractionSupport("org.eclipse.vtp.framework.interactions.voice.interaction");
        this.brandManager.addSupportedLanguage("org.eclipse.vtp.framework.interactions.voice.interaction", "Default");
        Brand defaultBrand = new Brand("Default");
        defaultBrand.registerMediaProvider("org.eclipse.vtp.framework.interactions.voice.interaction", "Default", (IMediaProvider)new StubMediaProvider());
        this.brandManager.setDefaultBrand(defaultBrand);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        FileEditorInput fileInput = (FileEditorInput)input;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            System.out.println(builder.getDOMImplementation().toString());
            System.out.println("supports namespaces: " + builder.isNamespaceAware());
            Document document = builder.parse(fileInput.getFile().getContents());
            Element rootElement = document.getDocumentElement();
            if (!rootElement.getTagName().equals("dialog-definition")) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            NodeList dialogList = rootElement.getElementsByTagName("model");
            if (dialogList.getLength() != 1) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            Element modelElement = (Element)dialogList.item(0);
            Model dialogModel = new Model((BrandManager)this.brandManager, modelElement, null);
            NodeList designList = rootElement.getElementsByTagName("design");
            if (designList.getLength() != 1) {
                throw new IllegalArgumentException("The file provided is not a valid dialog definition file");
            }
            Element designElement = (Element)designList.item(0);
            UIModel uiModel = new UIModel(dialogModel, designElement);
            this.renderedModel = new RenderedModel(uiModel);
            this.renderedModel.addListener(this);
            this.controller = new BasicController((BrandManager)this.brandManager, (RenderedCanvas)this.renderedModel.listRenderedCanvases().get(0));
            this.controller.setContainer((IAdaptable)this);
            this.controller.setResourceMap(this.resourceMap);
            this.canvasFrame = ThemeManager.getDefault().getDefaultTheme().createCanvasFrame((UICanvas)this.renderedModel.getUIModel().listUICanvases().get(0));
            site.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)new Action("Print"){

                public void run() {
                    Shell workbenchShell = Display.getCurrent().getActiveShell();
                    PrintDialog pd = new PrintDialog(workbenchShell);
                    pd.setStartPage(1);
                    pd.setEndPage(DialogEditor.this.renderedModel.getUIModel().listUICanvases().size());
                    PrinterData printerData = pd.open();
                    if (printerData != null) {
                        Printer printer = new Printer(printerData);
                        printer.startJob("Print Callflow");
                        List canvases = DialogEditor.this.renderedModel.listRenderedCanvases();
                        int i = printerData.startPage - 1;
                        while (i < Math.min(printerData.endPage, canvases.size())) {
                            RenderedCanvas canvas = (RenderedCanvas)canvases.get(i);
                            printer.startPage();
                            Point dpi = printer.getDPI();
                            System.out.println("printer dpi: " + dpi.x + ", " + dpi.y);
                            float scaleX = (float)dpi.x / 96.0f;
                            float scaleY = (float)dpi.y / 96.0f;
                            Rectangle clientArea = printer.getClientArea();
                            System.out.println("Client Area: " + clientArea);
                            int printerOrientation = clientArea.width > clientArea.height ? 2 : 1;
                            GC gc = new GC((Drawable)printer);
                            Transform transform = new Transform((Device)printer);
                            if (scaleX != 1.0f || scaleY != 1.0f) {
                                transform.scale(scaleX, scaleY);
                            }
                            if (canvas.getUICanvas().getOrientation() != printerOrientation) {
                                transform.translate((float)(canvas.getUICanvas().getHeight() / 2), (float)(canvas.getUICanvas().getHeight() / 2));
                                transform.rotate(90.0f);
                                transform.translate(-1.0f * (float)canvas.getUICanvas().getHeight() / 2.0f, -1.0f * (float)canvas.getUICanvas().getHeight() / 2.0f);
                            }
                            gc.setTransform(transform);
                            gc.setLineWidth(1);
                            canvas.paintCanvas(gc, DialogEditor.this.resourceMap, 16);
                            transform.dispose();
                            gc.dispose();
                            printer.endPage();
                            ++i;
                        }
                        printer.endJob();
                        printer.dispose();
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new PartInitException("Unable to read file", (Throwable)ex);
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IResource.class)) {
            return ((FileEditorInput)this.getEditorInput()).getFile();
        }
        return super.getAdapter(adapter);
    }

    public void createPartControl(Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ArrayList values = new ArrayList();
                values.addAll(DialogEditor.this.resourceMap.values());
                int i = 0;
                while (i < values.size()) {
                    if (values.get(i) instanceof Resource) {
                        ((Resource)values.get(i)).dispose();
                    }
                    ++i;
                }
                DialogEditor.this.resourceMap.clear();
            }
        });
        GC gc = new GC((Drawable)parent);
        this.renderedModel.initializeGraphics(gc, this.resourceMap);
        gc.dispose();
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.getVerticalBar().setIncrement(8);
        sc.getVerticalBar().setPageIncrement(15);
        final Composite canvasFrameComp = new Composite((Composite)sc, 0x20040000);
        sc.setContent((Control)canvasFrameComp);
        canvasFrameComp.setLayout((Layout)new FormLayout());
        canvasFrameComp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                DialogEditor.this.canvasFrame.setBounds(canvasFrameComp.getBounds());
            }
        });
        canvasFrameComp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                HashMap resourceMap = new HashMap();
                DialogEditor.this.canvasFrame.renderFrame(e.gc, 0, 0, resourceMap);
            }
        });
        RenderedCanvas rc = (RenderedCanvas)this.renderedModel.listRenderedCanvases().get(0);
        sc.setMinSize(rc.getUICanvas().getWidth() + this.canvasFrame.getInsets().x + this.canvasFrame.getInsets().width, rc.getUICanvas().getHeight() + this.canvasFrame.getInsets().y + this.canvasFrame.getInsets().height);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        this.canvas = new Canvas(canvasFrameComp, 0x20000000);
        this.canvas.setBackground(parent.getDisplay().getSystemColor(1));
        FormData fd = new FormData();
        fd.left = new FormAttachment(50, -1 * rc.getUICanvas().getWidth() / 2);
        fd.top = new FormAttachment(50, -1 * rc.getUICanvas().getHeight() / 2);
        fd.right = new FormAttachment(50, rc.getUICanvas().getWidth() / 2);
        fd.bottom = new FormAttachment(50, rc.getUICanvas().getHeight() / 2);
        this.canvas.setLayoutData((Object)fd);
        this.controller.setControl((Control)this.canvas);
        this.canvas.addPaintListener((PaintListener)this.controller);
        this.canvas.addMouseListener((MouseListener)this.controller);
        this.canvas.addMouseMoveListener((MouseMoveListener)this.controller);
        this.canvas.addMouseTrackListener((MouseTrackListener)this.controller);
        this.canvas.addKeyListener((KeyListener)this.controller);
        this.controller.addListener(this);
        this.hookContextMenu();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DialogEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        this.controller.fillContextMenu(manager);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor monitor) {
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "dialog-definition", null);
            Element rootElement = document.getDocumentElement();
            this.renderedModel.getUIModel().getModel().storeModel(rootElement);
            this.renderedModel.getUIModel().storeUIModel(rootElement);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            TransformerFactory transfactory = TransformerFactory.newInstance();
            Transformer t = transfactory.newTransformer();
            t.setOutputProperty("method", "xml");
            t.setOutputProperty("indent", "yes");
            t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            PrintWriter pw = new PrintWriter(baos);
            t.transform(new DOMSource(document), new XMLWriter(pw).toXMLResult());
            pw.flush();
            fileInput.getFile().setContents((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, true, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    public void setFocus() {
    }

    public void graphicUpdate(int x, int y, int width, int height, boolean inProgress) {
        this.canvas.redraw(x, y, width, height, false);
    }

    public void renderedModelChanged(RenderedModel renderedModel) {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public void selectionChanged(SelectionStructure selection) {
    }
}

