/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.editors.core.model.PaperSize;

public class PaperSizeManager {
    public static String paperSizeExtensionPointId = "org.eclipse.vtp.desktop.editors.core.paperSize";
    private static PaperSizeManager instance = new PaperSizeManager();
    private List paperSizes = new ArrayList();

    public static PaperSizeManager getDefault() {
        return instance;
    }

    public PaperSizeManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(paperSizeExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String id = primitiveExtensions[i].getAttribute("id");
            String name = primitiveExtensions[i].getAttribute("name");
            int portraitWidth = Integer.parseInt(primitiveExtensions[i].getAttribute("portraitWidth"));
            int portraitHeight = Integer.parseInt(primitiveExtensions[i].getAttribute("portraitHeight"));
            int landscapeWidth = Integer.parseInt(primitiveExtensions[i].getAttribute("landscapeWidth"));
            int landscapeHeight = Integer.parseInt(primitiveExtensions[i].getAttribute("landscapeHeight"));
            PaperSize paperSize = new PaperSize(id, name, portraitWidth, portraitHeight, landscapeWidth, landscapeHeight);
            this.paperSizes.add(paperSize);
            ++i;
        }
    }

    public List getPaperSizes() {
        return Collections.unmodifiableList(this.paperSizes);
    }

    public PaperSize getPaperSize(String id) {
        for (PaperSize paperSize : this.paperSizes) {
            if (!paperSize.getId().equals(id)) continue;
            return paperSize;
        }
        return null;
    }
}

