/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvasListener;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModel;
import org.eclipse.vtp.desktop.editors.core.model.SelectionResult;
import org.eclipse.vtp.desktop.editors.core.model.SelectionStructure;
import org.eclipse.vtp.desktop.editors.core.model.UICanvas;
import org.eclipse.vtp.desktop.editors.core.model.UICanvasListener;
import org.eclipse.vtp.desktop.editors.core.model.UIConnector;
import org.eclipse.vtp.desktop.editors.core.model.UIElement;
import org.eclipse.vtp.desktop.editors.core.theme.ComponentFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ComponentFrameListener;
import org.eclipse.vtp.desktop.editors.core.theme.ConnectorFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ElementFrame;
import org.eclipse.vtp.desktop.editors.core.theme.Theme;
import org.eclipse.vtp.desktop.editors.core.theme.ThemeManager;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.Element;

public class RenderedCanvas
implements ComponentFrameListener,
UICanvasListener {
    RenderedModel model = null;
    UICanvas canvas;
    private List elementFrames;
    List connectorFrames;
    SelectionStructure selection = null;
    boolean dirty = false;
    List listeners = new ArrayList();
    Theme theme = ThemeManager.getDefault().getCurrentTheme();

    public RenderedCanvas(RenderedModel model, UICanvas canvas) {
        this.model = model;
        this.canvas = canvas;
        canvas.addListener(this);
        this.elementFrames = new LinkedList();
        List uiElements = canvas.listUIElements();
        int i = 0;
        while (i < uiElements.size()) {
            UIElement uiElement = (UIElement)uiElements.get(i);
            ElementFrame elementFrame = this.theme.createElementFrame(uiElement);
            elementFrame.addListener(this);
            this.elementFrames.add(elementFrame);
            ++i;
        }
        this.connectorFrames = new LinkedList();
        List uiConnectors = canvas.listUIConnectors();
        int i2 = 0;
        while (i2 < uiConnectors.size()) {
            UIConnector uiConnector = (UIConnector)uiConnectors.get(i2);
            ElementFrame source = null;
            ElementFrame destination = null;
            for (ElementFrame ef : this.elementFrames) {
                if (ef.getUIElement().getElement().getId().equals(uiConnector.getUIOrigin().getElement().getId())) {
                    source = ef;
                }
                if (ef.getUIElement().getElement().getId().equals(uiConnector.getDestination().getElement().getId())) {
                    destination = ef;
                }
                if (source != null && destination != null) break;
            }
            ConnectorFrame connectorFrame = this.theme.createConnectorFrame(source, destination, uiConnector);
            connectorFrame.addListener(this);
            this.connectorFrames.add(connectorFrame);
            ++i2;
        }
        this.selection = new SelectionStructure(this);
    }

    public void initializeGraphics(GC gc, Map resourceMap) {
        for (ElementFrame ef : this.elementFrames) {
            ef.initializeGraphics(gc, resourceMap);
        }
        for (ConnectorFrame cf : this.connectorFrames) {
            cf.initializeGraphics(gc, resourceMap);
        }
    }

    public ElementFrame findElementAt(int x, int y) {
        int i = this.elementFrames.size() - 1;
        while (i > -1) {
            ElementFrame df = (ElementFrame)this.elementFrames.get(i);
            if (df.touchesComponent(x, y)) {
                return df;
            }
            --i;
        }
        return null;
    }

    public ConnectorFrame findConnectorAt(int x, int y) {
        for (ConnectorFrame cf : this.connectorFrames) {
            if (!cf.touchesComponent(x, y)) continue;
            return cf;
        }
        return null;
    }

    public ComponentFrame findComponentAt(int x, int y) {
        ComponentFrame cf = this.findElementAt(x, y);
        if (cf == null) {
            cf = this.findConnectorAt(x, y);
        }
        return cf;
    }

    public ElementFrame addElement(Element element, int x, int y) {
        ElementFrame ret = this.theme.createElementFrame(this.canvas.addElement(element, x, y));
        ret.addListener(this);
        this.elementFrames.add(ret);
        this.fireChange();
        return ret;
    }

    public ConnectorFrame connectElements(ElementFrame source, ElementFrame destination) {
        UIConnector connector = this.canvas.addConnector(new Connector(source.getUIElement().getElement(), destination.getUIElement().getElement()), source.getUIElement(), destination.getUIElement());
        ConnectorFrame ret = this.theme.createConnectorFrame(source, destination, connector);
        ret.addListener(this);
        this.connectorFrames.add(ret);
        this.fireChange();
        return ret;
    }

    public void paintCanvas(GC gc, Map resourceMap, int flags) {
        Rectangle r;
        Rectangle clipping = gc.getClipping();
        for (ComponentFrame ef : this.connectorFrames) {
            r = ef.getBounds();
            if (r != null && !r.isEmpty() && !r.intersects(clipping)) continue;
            ef.renderFrame(gc, 0, flags, resourceMap);
        }
        for (ComponentFrame ef : this.elementFrames) {
            r = ef.getBounds();
            if (r != null && !r.isEmpty() && !r.intersects(clipping)) continue;
            ef.renderFrame(gc, 0, flags, resourceMap);
        }
    }

    public SelectionResult selectAt(int x, int y, boolean additive) {
        ComponentFrame cof = this.findComponentAt(x, y);
        return this.selection.select(cof, additive);
    }

    public void selectRegion(Rectangle rect, boolean additive) {
        LinkedList<ElementFrame> selectList = new LinkedList<ElementFrame>();
        for (ElementFrame ef : this.elementFrames) {
            if (!ef.touchesElement(rect)) continue;
            selectList.add(ef);
        }
        this.selection.select(selectList, additive);
    }

    public UICanvas getUICanvas() {
        return this.canvas;
    }

    public SelectionStructure getSelection() {
        return this.selection;
    }

    public void deleteSelectedItems() {
        List items = this.selection.getSelectedItems();
        int i = 0;
        while (i < items.size()) {
            ComponentFrame cf = (ComponentFrame)items.get(i);
            if (cf instanceof ElementFrame) {
                ElementFrame ef = (ElementFrame)cf;
                this.model.getUIModel().getModel().removeElement(ef.getUIElement().getElement());
            } else {
                ConnectorFrame conf = (ConnectorFrame)cf;
                this.model.getUIModel().getModel().removeConnector(conf.getUIConnector().getConnector());
            }
            ++i;
        }
        this.selection.clear();
        this.fireChange();
        this.canvas.validateCanvasStatus();
    }

    public List getConnectorFrames() {
        return Collections.unmodifiableList(this.connectorFrames);
    }

    public List getElementFrames() {
        return Collections.unmodifiableList(this.elementFrames);
    }

    public void componentFrameChanged(ComponentFrame componentFrame) {
        this.fireChange();
    }

    public void addListener(RenderedCanvasListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(RenderedCanvasListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((RenderedCanvasListener)this.listeners.get(i)).renderedCanvasChanged(this);
            ++i;
        }
    }

    protected void fireFormatChange() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((RenderedCanvasListener)this.listeners.get(i)).renderedCanvasFormatChanged(this);
            ++i;
        }
    }

    protected void fireDeleted() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((RenderedCanvasListener)this.listeners.get(i)).renderedCanvasDeleted(this);
            ++i;
        }
    }

    public void componentFrameDeleted(ComponentFrame componentFrame) {
        System.out.println("Deleting: " + componentFrame);
        if (componentFrame instanceof ElementFrame) {
            this.elementFrames.remove(componentFrame);
        } else {
            this.connectorFrames.remove(componentFrame);
        }
    }

    public void componentFrameRepaintRequested(ComponentFrame componentFrame) {
        this.selection.validateSelection();
        this.fireChange();
    }

    public void canvasDeleted(UICanvas canvas) {
        this.fireDeleted();
    }

    public void orientationChanged(UICanvas canvas) {
        for (ElementFrame elementFrame : this.elementFrames) {
            Rectangle bounds = elementFrame.getBounds();
            int xoff = 0;
            int yoff = 0;
            if (bounds.x + bounds.width > canvas.getWidth()) {
                xoff = canvas.getWidth() - (bounds.x + bounds.width + 5);
            }
            if (bounds.y + bounds.height > canvas.getHeight()) {
                yoff = canvas.getHeight() - (bounds.y + bounds.height + 5);
            }
            if (xoff == 0 && yoff == 0) continue;
            elementFrame.adjustPosition(xoff, yoff);
        }
        this.selection.validateSelection();
        this.fireFormatChange();
    }

    public void paperSizeChanged(UICanvas canvas) {
        for (ElementFrame elementFrame : this.elementFrames) {
            Rectangle bounds = elementFrame.getBounds();
            int xoff = 0;
            int yoff = 0;
            if (bounds.x + bounds.width > canvas.getWidth()) {
                xoff = canvas.getWidth() - (bounds.x + bounds.width + 5);
            }
            if (bounds.y + bounds.height > canvas.getHeight()) {
                yoff = canvas.getHeight() - (bounds.y + bounds.height + 5);
            }
            if (xoff == 0 && yoff == 0) continue;
            elementFrame.adjustPosition(xoff, yoff);
        }
        this.selection.validateSelection();
        this.fireFormatChange();
    }

    public class ThemeListener
    implements IPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            event.getProperty().equals("CurrentTheme");
        }
    }
}

