/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvas;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvasListener;
import org.eclipse.vtp.desktop.editors.core.model.RenderedModelListener;
import org.eclipse.vtp.desktop.editors.core.model.UICanvas;
import org.eclipse.vtp.desktop.editors.core.model.UIModel;

public class RenderedModel
implements RenderedCanvasListener {
    private UIModel uiModel;
    List renderedCanvases = new ArrayList();
    boolean dirty = false;
    List listeners = new ArrayList();

    public RenderedModel(UIModel uiModel) {
        this.uiModel = uiModel;
        List uiCanvases = uiModel.listUICanvases();
        int i = 0;
        while (i < uiCanvases.size()) {
            RenderedCanvas renderedCanvas = new RenderedCanvas(this, (UICanvas)uiCanvases.get(i));
            renderedCanvas.addListener(this);
            this.renderedCanvases.add(renderedCanvas);
            ++i;
        }
    }

    public UIModel getUIModel() {
        return this.uiModel;
    }

    public void initializeGraphics(GC gc, Map resourceMap) {
        int i = 0;
        while (i < this.renderedCanvases.size()) {
            RenderedCanvas rc = (RenderedCanvas)this.renderedCanvases.get(i);
            rc.initializeGraphics(gc, resourceMap);
            ++i;
        }
    }

    public RenderedCanvas addRenderedCanvas(UICanvas uiCanvas) {
        RenderedCanvas renderedCanvas = new RenderedCanvas(this, uiCanvas);
        this.renderedCanvases.add(renderedCanvas);
        renderedCanvas.addListener(this);
        return renderedCanvas;
    }

    public RenderedCanvas getRenderedCanvas(String canvasId) {
        int i = 0;
        while (i < this.renderedCanvases.size()) {
            RenderedCanvas rc = (RenderedCanvas)this.renderedCanvases.get(i);
            if (rc.getUICanvas().getId().equals(canvasId)) {
                return rc;
            }
            ++i;
        }
        return null;
    }

    public List listRenderedCanvases() {
        return Collections.unmodifiableList(this.renderedCanvases);
    }

    public void renderedCanvasChanged(RenderedCanvas renderedCanvas) {
        this.fireChange();
    }

    public void addListener(RenderedModelListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(RenderedModelListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((RenderedModelListener)this.listeners.get(i)).renderedModelChanged(this);
            ++i;
        }
    }

    public void renderedCanvasDeleted(RenderedCanvas renderedCanvas) {
        this.renderedCanvases.remove(renderedCanvas);
        renderedCanvas.removeListener(this);
        this.fireChange();
    }

    public void renderedCanvasFormatChanged(RenderedCanvas renderedCanvas) {
    }
}

