/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.vtp.desktop.editors.core.model.RenderedCanvas;
import org.eclipse.vtp.desktop.editors.core.model.SelectionResult;
import org.eclipse.vtp.desktop.editors.core.theme.ComponentFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ConnectorFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ElementFrame;

public class SelectionStructure {
    private List selectedItems = new LinkedList();
    private List secondarySelections = new LinkedList();
    private List tertiarySelections = new LinkedList();
    private ComponentFrame primarySelection = null;
    private Rectangle selectionBounds = null;
    private RenderedCanvas renderedCanvas = null;
    int bufferedXoffset = 0;
    int bufferedYoffset = 0;

    public SelectionStructure(RenderedCanvas renderedCanvas) {
        this.renderedCanvas = renderedCanvas;
    }

    public void clear() {
        this.secondarySelections.clear();
        this.tertiarySelections.clear();
        Iterator si = this.selectedItems.iterator();
        while (si.hasNext()) {
            ((ComponentFrame)si.next()).setSelected(false);
        }
        this.selectedItems.clear();
        this.primarySelection = null;
        this.selectionBounds = null;
    }

    SelectionResult select(ComponentFrame cof, boolean additive) {
        SelectionResult result = new SelectionResult();
        if (cof != null && cof instanceof ElementFrame) {
            result.setHit(true);
            System.out.println("hit! " + cof);
            if (!additive) {
                if (!this.selectedItems.contains(cof)) {
                    this.secondarySelections.clear();
                    this.tertiarySelections.clear();
                    Iterator si = this.selectedItems.iterator();
                    while (si.hasNext()) {
                        ((ComponentFrame)si.next()).setSelected(false);
                    }
                    this.selectedItems.clear();
                    this.selectedItems.add(cof);
                    cof.setSelected(true);
                    this.primarySelection = cof;
                    this.addSecondaryAndTertiarySelections();
                    this.selectionBounds = null;
                    result.setSelectionChanged(true);
                    result.setPrimaryChanged(true);
                } else if (this.primarySelection != cof) {
                    result.setSelectionChanged(false);
                    result.setPrimaryChanged(true);
                    this.selectedItems.remove(cof);
                    this.selectedItems.add(0, cof);
                    this.primarySelection = cof;
                    this.selectionBounds = null;
                }
                return result;
            }
            this.secondarySelections.clear();
            this.tertiarySelections.clear();
            if (this.selectedItems.contains(cof)) {
                System.out.println("single deselection");
                this.selectedItems.remove(cof);
                cof.setSelected(false);
                if (this.selectedItems.size() > 0) {
                    this.primarySelection = (ComponentFrame)this.selectedItems.get(0);
                    this.addSecondaryAndTertiarySelections();
                } else {
                    this.primarySelection = null;
                }
                this.selectionBounds = null;
                result.setSelectionChanged(true);
                result.setPrimaryChanged(true);
                return result;
            }
            if (this.primarySelection != null && this.primarySelection instanceof ConnectorFrame) {
                this.primarySelection.setSelected(false);
                this.selectedItems.clear();
            }
            this.selectedItems.add(0, cof);
            this.primarySelection = cof;
            this.primarySelection.setSelected(true);
            this.addSecondaryAndTertiarySelections();
            this.selectionBounds = null;
            result.setSelectionChanged(true);
            result.setPrimaryChanged(true);
            return result;
        }
        if (cof != null && cof instanceof ConnectorFrame) {
            result.setHit(true);
            if (!additive) {
                if (this.primarySelection != cof) {
                    this.secondarySelections.clear();
                    this.tertiarySelections.clear();
                    Iterator si = this.selectedItems.iterator();
                    while (si.hasNext()) {
                        ((ComponentFrame)si.next()).setSelected(false);
                    }
                    this.selectedItems.clear();
                    this.selectedItems.add(cof);
                    cof.setSelected(true);
                    this.primarySelection = cof;
                    this.selectionBounds = null;
                    result.setSelectionChanged(true);
                    result.setPrimaryChanged(true);
                } else {
                    result.setSelectionChanged(false);
                    result.setPrimaryChanged(false);
                }
            } else {
                this.secondarySelections.clear();
                this.tertiarySelections.clear();
                this.selectedItems.clear();
                if (this.primarySelection == cof) {
                    cof.setSelected(false);
                    this.primarySelection = null;
                } else {
                    this.selectedItems.add(cof);
                    cof.setSelected(true);
                    this.primarySelection = cof;
                }
                this.selectionBounds = null;
                result.setSelectionChanged(true);
                result.setPrimaryChanged(true);
            }
            return result;
        }
        if (cof == null && !additive) {
            if (this.primarySelection != null) {
                this.secondarySelections.clear();
                this.tertiarySelections.clear();
                Iterator si = this.selectedItems.iterator();
                while (si.hasNext()) {
                    ((ComponentFrame)si.next()).setSelected(false);
                }
                this.selectedItems.clear();
                this.primarySelection = null;
                this.selectionBounds = null;
                result.setSelectionChanged(true);
                result.setPrimaryChanged(true);
            }
        } else {
            result.setSelectionChanged(false);
            result.setPrimaryChanged(false);
        }
        return result;
    }

    void select(List selectionList, boolean additive) {
        this.secondarySelections.clear();
        this.tertiarySelections.clear();
        if (!additive) {
            Iterator si = this.selectedItems.iterator();
            while (si.hasNext()) {
                ((ComponentFrame)si.next()).setSelected(false);
            }
            this.selectedItems.clear();
        }
        for (ElementFrame ef : selectionList) {
            System.out.println("hit! " + ef);
            this.selectedItems.remove(ef);
            this.selectedItems.add(0, ef);
            ef.setSelected(true);
            this.primarySelection = ef;
            this.selectionBounds = null;
        }
        if (this.primarySelection != null) {
            this.addSecondaryAndTertiarySelections();
        }
    }

    public void validateSelection() {
        this.selectionBounds = null;
        if (this.primarySelection instanceof ElementFrame) {
            this.secondarySelections.clear();
            this.tertiarySelections.clear();
            this.addSecondaryAndTertiarySelections();
        }
    }

    private void addSecondaryAndTertiarySelections() {
        for (ConnectorFrame cf : this.renderedCanvas.getConnectorFrames()) {
            ElementFrame originFrame = null;
            ElementFrame destinationFrame = null;
            for (ElementFrame ef : this.selectedItems) {
                if (cf.getUIConnector().getUIOrigin() == ef.getUIElement()) {
                    originFrame = ef;
                }
                if (cf.getUIConnector().getDestination() == ef.getUIElement()) {
                    destinationFrame = ef;
                }
                if (originFrame != null && destinationFrame != null) break;
            }
            if (originFrame != null && destinationFrame != null) {
                this.secondarySelections.add(cf);
                continue;
            }
            if (originFrame == null && destinationFrame == null) continue;
            this.tertiarySelections.add(cf);
        }
    }

    public Rectangle getBounds() {
        if (this.selectionBounds == null) {
            Iterator iterator = this.selectedItems.iterator();
            while (iterator.hasNext()) {
                if (this.selectionBounds == null) {
                    this.selectionBounds = ((ComponentFrame)iterator.next()).getBounds();
                    continue;
                }
                this.selectionBounds.add(((ComponentFrame)iterator.next()).getBounds());
            }
            iterator = this.secondarySelections.iterator();
            while (iterator.hasNext()) {
                this.selectionBounds.add(((ComponentFrame)iterator.next()).getBounds());
            }
        }
        return this.selectionBounds == null ? null : new Rectangle(this.selectionBounds.x, this.selectionBounds.y, this.selectionBounds.width, this.selectionBounds.height);
    }

    public Rectangle getTertiaryBounds() {
        Rectangle sb = this.getBounds();
        if (sb == null) {
            return null;
        }
        Rectangle rect = new Rectangle(sb.x, sb.y, sb.width, sb.height);
        Iterator iterator = this.tertiarySelections.iterator();
        while (iterator.hasNext()) {
            rect.add(((ComponentFrame)iterator.next()).getBounds());
        }
        return rect;
    }

    public void alignEdge(int edge) {
        if (this.primarySelection instanceof ElementFrame) {
            Rectangle r = this.primarySelection.getBounds();
            int xy = 0;
            if (edge == 16384) {
                xy = r.x;
            } else if (edge == 128) {
                xy = r.y;
            } else if (edge == 131072) {
                xy = r.x + r.width;
            } else if (edge == 1024) {
                xy = r.y + r.height;
            } else {
                return;
            }
            Iterator iterator = this.selectedItems.iterator();
            while (iterator.hasNext()) {
                ((ElementFrame)iterator.next()).alignEdge(edge, xy);
            }
        }
    }

    public void alignCenter(int orientation) {
        if (this.primarySelection instanceof ElementFrame) {
            Point p = ((ElementFrame)this.primarySelection).getUIElement().getCenterPoint();
            int xy = 0;
            if (orientation == 256) {
                xy = p.y;
            } else if (orientation == 512) {
                xy = p.x;
            } else {
                return;
            }
            Iterator iterator = this.selectedItems.iterator();
            while (iterator.hasNext()) {
                ((ElementFrame)iterator.next()).alignCenter(orientation, xy);
            }
        }
    }

    public void adjustPosition(int xoffset, int yoffset) {
        Rectangle rect = this.getBounds();
        if (xoffset < 0) {
            if (rect.x + xoffset < 0) {
                this.bufferedXoffset += xoffset + rect.x;
                xoffset = rect.x * -1;
            } else {
                this.bufferedXoffset += xoffset;
                if (this.bufferedXoffset < 0) {
                    xoffset = this.bufferedXoffset;
                    this.bufferedXoffset = 0;
                } else {
                    xoffset = 0;
                }
            }
        } else if (xoffset > 0) {
            if (rect.x + rect.width + xoffset > this.renderedCanvas.getUICanvas().getWidth()) {
                this.bufferedXoffset += xoffset - (this.renderedCanvas.getUICanvas().getWidth() - (rect.x + rect.width));
                xoffset = this.renderedCanvas.getUICanvas().getWidth() - (rect.x + rect.width);
            } else {
                this.bufferedXoffset += xoffset;
                if (this.bufferedXoffset > 0) {
                    xoffset = this.bufferedXoffset;
                    this.bufferedXoffset = 0;
                } else {
                    xoffset = 0;
                }
            }
        }
        if (yoffset < 0) {
            if (rect.y + yoffset < 0) {
                this.bufferedYoffset += yoffset + rect.y;
                yoffset = rect.y * -1;
            } else {
                this.bufferedYoffset += yoffset;
                if (this.bufferedYoffset < 0) {
                    yoffset = this.bufferedYoffset;
                    this.bufferedYoffset = 0;
                } else {
                    yoffset = 0;
                }
            }
        } else if (yoffset > 0) {
            if (rect.y + rect.height + yoffset > this.renderedCanvas.getUICanvas().getHeight()) {
                this.bufferedYoffset += yoffset - (this.renderedCanvas.getUICanvas().getHeight() - (rect.y + rect.height));
                yoffset = this.renderedCanvas.getUICanvas().getHeight() - (rect.y + rect.height);
            } else {
                this.bufferedYoffset += yoffset;
                if (this.bufferedYoffset > 0) {
                    yoffset = this.bufferedYoffset;
                    this.bufferedYoffset = 0;
                } else {
                    yoffset = 0;
                }
            }
        }
        Iterator iterator = this.selectedItems.iterator();
        while (iterator.hasNext()) {
            ((ComponentFrame)iterator.next()).adjustPosition(xoffset, yoffset);
        }
        iterator = this.secondarySelections.iterator();
        while (iterator.hasNext()) {
            ((ComponentFrame)iterator.next()).adjustPosition(xoffset, yoffset);
        }
        if (this.primarySelection instanceof ElementFrame) {
            this.selectionBounds.x += xoffset;
            this.selectionBounds.y += yoffset;
        } else {
            this.selectionBounds = null;
        }
    }

    public ComponentFrame getPrimarySelection() {
        return this.primarySelection;
    }

    public List getSelectedItems() {
        return Collections.unmodifiableList(this.selectedItems);
    }
}

