/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.vtp.desktop.editors.core.model.PaperSize;
import org.eclipse.vtp.desktop.editors.core.model.PaperSizeManager;
import org.eclipse.vtp.desktop.editors.core.model.UICanvasListener;
import org.eclipse.vtp.desktop.editors.core.model.UIComponent;
import org.eclipse.vtp.desktop.editors.core.model.UIComponentListener;
import org.eclipse.vtp.desktop.editors.core.model.UIConnector;
import org.eclipse.vtp.desktop.editors.core.model.UIElement;
import org.eclipse.vtp.desktop.editors.core.model.UIModel;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.framework.util.Guid;
import org.w3c.dom.NodeList;

public class UICanvas
implements UIComponentListener {
    private String id;
    private String name;
    private UIModel uiModel;
    private int orientation = 2;
    private PaperSize paperSize = null;
    private List uiElements = new ArrayList();
    private List uiConnectors = new ArrayList();
    private List listeners = new ArrayList();

    public UICanvas(UIModel uiModel, String name) {
        this.id = Guid.createGUID();
        this.name = name;
        this.uiModel = uiModel;
        this.paperSize = PaperSizeManager.getDefault().getPaperSize("org.eclipse.vtp.desktop.editors.core.Letter");
    }

    public UICanvas(UIModel uiModel, org.w3c.dom.Element canvasElement) {
        this.id = canvasElement.getAttribute("id");
        this.name = canvasElement.getAttribute("name");
        if (!canvasElement.getAttribute("orientation").equals("")) {
            this.orientation = Integer.parseInt(canvasElement.getAttribute("orientation"));
        }
        this.uiModel = uiModel;
        String paperSizeId = canvasElement.getAttribute("paper-size");
        this.paperSize = paperSizeId != null && !paperSizeId.equals("") ? PaperSizeManager.getDefault().getPaperSize(paperSizeId) : PaperSizeManager.getDefault().getPaperSize("org.eclipse.vtp.desktop.editors.core.Letter");
        NodeList uiElementList = canvasElement.getElementsByTagName("ui-element");
        int ue = 0;
        while (ue < uiElementList.getLength()) {
            org.w3c.dom.Element uiElementElement = (org.w3c.dom.Element)uiElementList.item(ue);
            List elements = uiModel.getModel().listElements();
            int i = 0;
            while (i < elements.size()) {
                Element element = (Element)elements.get(i);
                if (element.getId().equals(uiElementElement.getAttribute("id"))) {
                    UIElement element2 = new UIElement(element, uiElementElement);
                    element2.addListener(this);
                    this.uiElements.add(element2);
                    break;
                }
                ++i;
            }
            ++ue;
        }
        NodeList uiConnectorList = canvasElement.getElementsByTagName("ui-connector");
        int ue2 = 0;
        while (ue2 < uiConnectorList.getLength()) {
            org.w3c.dom.Element uiConnectorElement = (org.w3c.dom.Element)uiConnectorList.item(ue2);
            List connectors = uiModel.getModel().listConnectors();
            int i = 0;
            while (i < connectors.size()) {
                Connector connector = (Connector)connectors.get(i);
                if (connector.getId().equals(uiConnectorElement.getAttribute("id"))) {
                    UIElement origin = null;
                    UIElement destination = null;
                    int e = 0;
                    while (e < this.uiElements.size()) {
                        UIElement uiElement = (UIElement)this.uiElements.get(e);
                        if (uiElement.getElement().equals(connector.getOrigin())) {
                            origin = uiElement;
                        }
                        if (uiElement.getElement().equals(connector.getDestination())) {
                            destination = uiElement;
                        }
                        ++e;
                    }
                    if (origin == null || destination == null) break;
                    UIConnector connector2 = new UIConnector(uiConnectorElement, connector, origin, destination);
                    connector2.addListener(this);
                    this.uiConnectors.add(connector2);
                    break;
                }
                ++i;
            }
            ++ue2;
        }
    }

    public UIModel getUIModel() {
        return this.uiModel;
    }

    public void storeCanvas(org.w3c.dom.Element designElement) {
        org.w3c.dom.Element canvasElement = designElement.getOwnerDocument().createElement("canvas");
        designElement.appendChild(canvasElement);
        canvasElement.setAttribute("id", this.id);
        canvasElement.setAttribute("name", this.name);
        canvasElement.setAttribute("orientation", Integer.toString(this.orientation));
        canvasElement.setAttribute("paper-size", this.paperSize.getId());
        int i = 0;
        while (i < this.uiElements.size()) {
            UIElement uiElement = (UIElement)this.uiElements.get(i);
            uiElement.storeUIElement(canvasElement);
            ++i;
        }
        i = 0;
        while (i < this.uiConnectors.size()) {
            UIConnector uiConnector = (UIConnector)this.uiConnectors.get(i);
            uiConnector.storeUIConnector(canvasElement);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 2) {
            throw new IllegalArgumentException("Canvas orientation must be one of UIConstants.PORTRAIT | UIConstants.LANDSCAPE");
        }
        this.orientation = orientation;
        this.fireOrientationChanged();
    }

    public void setPaperSize(PaperSize paperSize) {
        this.paperSize = paperSize;
        this.firePaperSizeChanged();
    }

    public int getWidth() {
        return this.orientation == 1 ? this.paperSize.getPortraitPixelWidth() : this.paperSize.getLandscapePixelWidth();
    }

    public int getHeight() {
        return this.orientation == 1 ? this.paperSize.getPortraitPixelHeight() : this.paperSize.getLandscapePixelHeight();
    }

    public List listUIElements() {
        return Collections.unmodifiableList(this.uiElements);
    }

    public void removeElement(UIElement uiElement) {
        if (this.uiElements.remove(uiElement)) {
            this.uiModel.getModel().removeElement(uiElement.getElement());
        }
    }

    public UIElement addElement(Element element, int x, int y) {
        UIElement uiElement = new UIElement(element);
        uiElement.setCenterPoint(new Point(x, y));
        this.uiModel.getModel().addElement(element);
        this.uiElements.add(uiElement);
        return uiElement;
    }

    public List listUIConnectors() {
        return Collections.unmodifiableList(this.uiConnectors);
    }

    public void removeConnector(UIConnector uiConnector) {
        if (this.uiConnectors.remove(uiConnector)) {
            this.uiModel.getModel().removeConnector(uiConnector.getConnector());
        }
    }

    public UIConnector addConnector(Connector connector, UIElement origin, UIElement destination) {
        UIConnector uiConnector = new UIConnector(connector, origin, destination);
        this.uiModel.getModel().addConnector(connector);
        this.uiConnectors.add(uiConnector);
        if (origin == destination) {
            uiConnector.addMidPoint(origin.getCenterPoint().x + 70, origin.getCenterPoint().y - 30);
            uiConnector.addMidPoint(origin.getCenterPoint().x + 70, origin.getCenterPoint().y + 30);
        }
        return uiConnector;
    }

    public void componentChanged(UIComponent component) {
    }

    public void componentDeleted(UIComponent component) {
        System.out.println("deleting: " + component);
        if (component instanceof UIConnector) {
            this.uiConnectors.remove(component);
        } else {
            this.uiElements.remove(component);
        }
    }

    public void delete() {
        Object[] a_uiElements = this.uiElements.toArray();
        int i = 0;
        while (i < a_uiElements.length) {
            UIElement uiElement = (UIElement)a_uiElements[i];
            uiElement.getElement().getModel().removeElement(uiElement.getElement());
            ++i;
        }
        this.fireDeleted();
    }

    private void fireOrientationChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((UICanvasListener)this.listeners.get(i)).orientationChanged(this);
            ++i;
        }
    }

    private void firePaperSizeChanged() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((UICanvasListener)this.listeners.get(i)).paperSizeChanged(this);
            ++i;
        }
    }

    private void fireDeleted() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((UICanvasListener)this.listeners.get(i)).canvasDeleted(this);
            ++i;
        }
    }

    public void addListener(UICanvasListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(UICanvasListener listener) {
        this.listeners.remove(listener);
    }

    public void validateCanvasStatus() {
        for (UIElement element : this.uiElements) {
            element.getElement().validateStatus();
        }
    }
}

