/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.editors.core.model.UIComponentListener;
import org.eclipse.vtp.desktop.model.core.Component;
import org.eclipse.vtp.desktop.model.core.ComponentListener;

public class UIComponent
implements ComponentListener,
PropertyChangeListener {
    private List listeners = new ArrayList();
    private List propertyListeners = new ArrayList();

    public void componentChanged(Component component) {
        this.fireChange();
    }

    public void addListener(UIComponentListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(UIComponentListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((UIComponentListener)this.listeners.get(i)).componentChanged(this);
            ++i;
        }
    }

    protected void fireDelete() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((UIComponentListener)this.listeners.get(i)).componentDeleted(this);
            ++i;
        }
    }

    public void componentDeleted(Component component) {
        System.out.println("received delete from: " + component);
        this.fireDelete();
    }

    public void addPropertyListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
        this.propertyListeners.add(listener);
    }

    public void removePropertyListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        int i = 0;
        while (i < this.propertyListeners.size()) {
            ((PropertyChangeListener)this.propertyListeners.get(i)).propertyChange(event);
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }
}

