/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.vtp.desktop.editors.core.model.UIComponent;
import org.eclipse.vtp.desktop.editors.core.model.UIElement;
import org.eclipse.vtp.desktop.model.core.ComponentListener;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UIConnector
extends UIComponent {
    private Connector connector;
    private List points = new ArrayList();
    UIElement origin = null;
    UIElement destination = null;
    LineLabel label = null;

    public UIConnector(Connector connector, UIElement origin, UIElement destination) {
        this.connector = connector;
        connector.addListener((ComponentListener)this);
        connector.addPropertyListener((PropertyChangeListener)this);
        this.origin = origin;
        this.destination = destination;
        this.points.add(new ConnectorEndPoint(origin));
        this.points.add(new ConnectorEndPoint(destination));
        this.label = new LineLabel();
    }

    public UIConnector(Element connectorDesign, Connector connector, UIElement origin, UIElement destination) {
        this(connector, origin, destination);
        int segment = 0;
        int lx = 0;
        int ly = 0;
        try {
            segment = Integer.parseInt(connectorDesign.getAttribute("label-segment"));
            lx = Integer.parseInt(connectorDesign.getAttribute("label-x"));
            ly = Integer.parseInt(connectorDesign.getAttribute("label-y"));
        }
        catch (Exception exception) {}
        this.label.setLabelLocation(segment, lx, ly);
        NodeList midPointList = connectorDesign.getElementsByTagName("mid-point");
        int i = 0;
        while (i < midPointList.getLength()) {
            Element midPointElement = (Element)midPointList.item(i);
            int x = Integer.parseInt(midPointElement.getAttribute("x"));
            int y = Integer.parseInt(midPointElement.getAttribute("y"));
            this.addMidPoint(x, y);
            ++i;
        }
    }

    public void storeUIConnector(Element canvasElement) {
        Element connectorElement = canvasElement.getOwnerDocument().createElement("ui-connector");
        canvasElement.appendChild(connectorElement);
        connectorElement.setAttribute("id", this.connector.getId());
        connectorElement.setAttribute("label-segment", Integer.toString(this.label.getLinePointIndex()));
        connectorElement.setAttribute("label-x", Integer.toString(this.label.getXOffset()));
        connectorElement.setAttribute("label-y", Integer.toString(this.label.getYOffset()));
        for (MidPoint mp : this.getMidPoints()) {
            Element midPointElement = connectorElement.getOwnerDocument().createElement("mid-point");
            connectorElement.appendChild(midPointElement);
            midPointElement.setAttribute("x", Integer.toString(mp.mx));
            midPointElement.setAttribute("y", Integer.toString(mp.my));
        }
    }

    public Connector getConnector() {
        return this.connector;
    }

    public UIElement getUIOrigin() {
        return this.origin;
    }

    public UIElement getDestination() {
        return this.destination;
    }

    public LineLabel getLabel() {
        return this.label;
    }

    public Point[] getPoints() {
        Point[] ps = new Point[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            ps[i] = i == this.points.size() - 1 ? ((GraphPoint)this.points.get(i)).getPoint(((GraphPoint)this.points.get(i - 1)).getRegistryPoint()) : ((GraphPoint)this.points.get(i)).getPoint(((GraphPoint)this.points.get(i + 1)).getRegistryPoint());
            if (ps[i] == null) {
                ps[i] = ((GraphPoint)this.points.get(i)).getRegistryPoint();
            }
            ++i;
        }
        return ps;
    }

    public List getMidPoints() {
        ArrayList ret = new ArrayList();
        int i = 1;
        while (i < this.points.size() - 1) {
            ret.add(this.points.get(i));
            ++i;
        }
        return Collections.unmodifiableList(ret);
    }

    public void addMidPoint(int x, int y) {
        this.points.add(this.points.size() - 1, new MidPoint(x, y));
    }

    public void insertMidPoint(int index, int x, int y) {
        this.points.add(index, new MidPoint(x, y));
        this.fireChange();
    }

    public void removeMidPoint(int index) {
        this.points.remove(index);
        this.fireChange();
    }

    public class ConnectorEndPoint
    implements GraphPoint {
        UIElement terminus;

        public ConnectorEndPoint(UIElement terminus) {
            this.terminus = terminus;
        }

        public Point getPoint(Point originPoint) {
            return this.terminus.getCenterPoint();
        }

        public Point getRegistryPoint() {
            return this.terminus.getCenterPoint();
        }

        public void adjustPosition(int xoff, int yoff) {
        }
    }

    public static interface GraphPoint {
        public Point getPoint(Point var1);

        public Point getRegistryPoint();

        public void adjustPosition(int var1, int var2);
    }

    public class LineLabel {
        private int lox = 0;
        private int loy = 0;
        private int linePointIndex = 0;

        public void setLabelLocation(int segment, int lox, int loy) {
            Point[] points = UIConnector.this.getPoints();
            if (segment < 0 || segment >= points.length - 1) {
                segment = 0;
                lox = 0;
                loy = 0;
            }
            this.linePointIndex = segment;
            this.lox = lox;
            this.loy = loy;
        }

        public void resetLocation() {
            this.linePointIndex = 0;
            this.lox = 0;
            this.loy = 0;
        }

        public int getLinePointIndex() {
            return this.linePointIndex;
        }

        public int getXOffset() {
            return this.lox;
        }

        public int getYOffset() {
            return this.loy;
        }
    }

    public class MidPoint
    implements GraphPoint {
        int mx = 0;
        int my = 0;

        public MidPoint(int x, int y) {
            this.mx = x;
            this.my = y;
        }

        public Point getPoint(Point originPoint) {
            return new Point(this.mx, this.my);
        }

        public Point getRegistryPoint() {
            return new Point(this.mx, this.my);
        }

        public void adjustPosition(int xoff, int yoff) {
            this.mx += xoff;
            this.my += yoff;
        }
    }
}

