/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.editors.core.model.UICanvas;
import org.eclipse.vtp.desktop.editors.core.model.UICanvasListener;
import org.eclipse.vtp.desktop.model.core.Model;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UIModel
implements UICanvasListener {
    private Model model;
    List uiCanvases = new ArrayList();

    public UIModel(Model model) {
        this.model = model;
    }

    public UIModel(Model model, Element modelDesign) {
        this.model = model;
        NodeList canvasElementList = modelDesign.getElementsByTagName("canvas");
        int i = 0;
        while (i < canvasElementList.getLength()) {
            Element canvasElement = (Element)canvasElementList.item(i);
            UICanvas canvas = new UICanvas(this, canvasElement);
            this.uiCanvases.add(canvas);
            canvas.addListener(this);
            ++i;
        }
    }

    public void storeUIModel(Element rootElement) {
        Element modelElement = rootElement.getOwnerDocument().createElement("design");
        rootElement.appendChild(modelElement);
        int i = 0;
        while (i < this.uiCanvases.size()) {
            UICanvas uiCanvas = (UICanvas)this.uiCanvases.get(i);
            uiCanvas.storeCanvas(modelElement);
            ++i;
        }
    }

    public Model getModel() {
        return this.model;
    }

    public List listUICanvases() {
        return Collections.unmodifiableList(this.uiCanvases);
    }

    public void addCanvas(UICanvas canvas) {
        this.uiCanvases.remove(canvas);
        this.uiCanvases.add(canvas);
        canvas.addListener(this);
    }

    public void removeCanvas(UICanvas canvas) {
        canvas.delete();
    }

    public void canvasDeleted(UICanvas canvas) {
        this.uiCanvases.remove(canvas);
        canvas.removeListener(this);
    }

    public void orientationChanged(UICanvas canvas) {
    }

    public void paperSizeChanged(UICanvas canvas) {
    }
}

