/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.preferences;

import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.vtp.desktop.editors.core.Activator;
import org.eclipse.vtp.desktop.editors.core.theme.Theme;
import org.eclipse.vtp.desktop.editors.core.theme.ThemeManager;

public class ThemePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List themes = ThemeManager.getDefault().getInstalledThemes();
    Combo themeCombo = null;

    public ThemePreferencePage() {
    }

    public ThemePreferencePage(String title) {
        super(title);
    }

    public ThemePreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        Label themeLabel = new Label(comp, 0);
        themeLabel.setText("Editor Theme:");
        themeLabel.setLayoutData((Object)new GridData());
        this.themeCombo = new Combo(comp, 12);
        int selected = -1;
        int defaultSelected = -1;
        int i = 0;
        while (i < this.themes.size()) {
            Theme theme = (Theme)this.themes.get(i);
            this.themeCombo.add(theme.getName());
            if (theme.getId().equals(ThemeManager.getDefault().getDefaultTheme().getId())) {
                defaultSelected = i;
            }
            if (theme.getId().equals(ThemeManager.getDefault().getCurrentTheme().getId())) {
                selected = i;
            }
            ++i;
        }
        if (selected != -1) {
            this.themeCombo.select(selected);
        } else if (defaultSelected != -1) {
            this.themeCombo.select(defaultSelected);
        }
        this.themeCombo.setLayoutData((Object)new GridData(768));
        return comp;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("CurrentTheme", ((Theme)this.themes.get(this.themeCombo.getSelectionIndex())).getId());
        return super.performOk();
    }
}

