/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.core.theme;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.vtp.desktop.editors.core.Activator;
import org.eclipse.vtp.desktop.editors.core.theme.Theme;
import org.osgi.framework.Bundle;

public class ThemeManager {
    public static String themeExtensionPointId = "org.eclipse.vtp.desktop.editors.core.editorTheme";
    private static ThemeManager instance = new ThemeManager();
    private Map primitiveTypes = new HashMap();

    public static ThemeManager getDefault() {
        return instance;
    }

    public ThemeManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(themeExtensionPointId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String id = primitiveExtensions[i].getAttribute("id");
            System.out.println("found theme: " + id);
            primitiveExtensions[i].getAttribute("name");
            String className = primitiveExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
            try {
                Class providerClass = contributor.loadClass(className);
                this.primitiveTypes.put(id, providerClass.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public List getInstalledThemes() {
        LinkedList ret = new LinkedList();
        ret.addAll(this.primitiveTypes.values());
        return ret;
    }

    public Theme getDefaultTheme() {
        return (Theme)this.primitiveTypes.get("org.eclipse.vtp.desktop.editors.themes.attraction");
    }

    public Theme getCurrentTheme() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String themeId = store.getString("CurrentTheme");
        Theme theme = (Theme)this.primitiveTypes.get(themeId);
        if (theme == null) {
            theme = this.getDefaultTheme();
        }
        return theme;
    }
}

