/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.editors.themes.mantis;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.vtp.desktop.editors.core.commands.Command;
import org.eclipse.vtp.desktop.editors.core.commands.CommandListener;
import org.eclipse.vtp.desktop.editors.core.commands.ShowProperties;
import org.eclipse.vtp.desktop.editors.core.model.UIComponent;
import org.eclipse.vtp.desktop.editors.core.model.UIComponentListener;
import org.eclipse.vtp.desktop.editors.core.theme.ComponentFrame;
import org.eclipse.vtp.desktop.editors.core.theme.ComponentFrameListener;

public abstract class MantisComponentFrame
implements ComponentFrame,
UIComponentListener,
PropertyChangeListener {
    private List listeners = new ArrayList();

    public void addListener(ComponentFrameListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(ComponentFrameListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ComponentFrameListener)this.listeners.get(i)).componentFrameChanged((ComponentFrame)this);
            ++i;
        }
    }

    protected void fireDelete() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ComponentFrameListener)this.listeners.get(i)).componentFrameDeleted((ComponentFrame)this);
            ++i;
        }
    }

    public void componentChanged(UIComponent component) {
        this.fireChange();
    }

    public void mouseDoubleClick(CommandListener commandListener, int x, int y, int modifiers) {
        commandListener.executeCommand((Command)new ShowProperties());
    }

    public void componentDeleted(UIComponent component) {
        System.out.println("Recieved delete: " + component);
        this.fireDelete();
    }

    protected void fireRepaintRequest() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ComponentFrameListener)this.listeners.get(i)).componentFrameRepaintRequested((ComponentFrame)this);
            ++i;
        }
    }

    public void renderFrame(GC graphicsContext, int stage, int renderFlags, Map resourceMap) {
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected Color getColor(GC gc, Map resourceMap, String name, int r, int g, int b) {
        Object obj = resourceMap.get(name);
        if (obj == null) {
            obj = new Color(gc.getDevice(), r, g, b);
            resourceMap.put(name, obj);
        }
        return (Color)obj;
    }

    protected Font getFont(GC gc, Map resourceMap, String name, String fontName, int size, int style) {
        Object obj = resourceMap.get(name);
        if (obj == null) {
            obj = new Font(gc.getDevice(), fontName, size, style);
            resourceMap.put(name, obj);
        }
        return (Font)obj;
    }
}

