/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.core.InteractionType;

public class InteractionTypeManager {
    public static final String interactionTypeExtensionId = "org.eclipse.vtp.framework.interactions.core.interactionTypes";
    private static final InteractionTypeManager INSTANCE = new InteractionTypeManager();
    private List interactionTypes = new ArrayList();
    private Map interactionTypesById = new HashMap();

    public static InteractionTypeManager getInstance() {
        return INSTANCE;
    }

    public InteractionTypeManager() {
        IConfigurationElement[] formatterExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(interactionTypeExtensionId);
        int i = 0;
        while (i < formatterExtensions.length) {
            InteractionType it = new InteractionType(formatterExtensions[i].getAttribute("id"), formatterExtensions[i].getAttribute("name"));
            this.interactionTypes.add(it);
            this.interactionTypesById.put(it.getId(), it);
            System.out.println("Registered interaction type: " + it.getId());
            ++i;
        }
    }

    public List getInteractionTypes() {
        return Collections.unmodifiableList(this.interactionTypes);
    }

    public InteractionType getType(String typeId) {
        return (InteractionType)this.interactionTypesById.get(typeId);
    }
}

