/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.actions.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.vtp.desktop.core.actions.util.DynamicMenuManager;
import org.eclipse.vtp.desktop.core.actions.util.IProvisioningActionItemSorter;
import org.eclipse.vtp.desktop.core.actions.util.IProvisioningModelSelection;
import org.eclipse.vtp.desktop.core.actions.util.InternalAction;
import org.eclipse.vtp.desktop.core.actions.util.InternalActionItem;
import org.eclipse.vtp.desktop.core.actions.util.InternalActionItemContainer;
import org.eclipse.vtp.desktop.core.actions.util.InternalActionSet;
import org.eclipse.vtp.desktop.core.actions.util.SectionConstraint;

public class InternalActionSetSection
implements InternalActionItemContainer {
    private List actionItemList = new ArrayList();
    private Map actionSetMap = new HashMap();
    private String containerId;
    private String name;
    private IProvisioningActionItemSorter sorter;
    private SectionConstraint location;

    public InternalActionSetSection(String containerId, String name, SectionConstraint location) {
        this.containerId = containerId;
        this.name = name;
        this.location = location;
    }

    public void setSorter(IProvisioningActionItemSorter sorter) {
        this.sorter = sorter;
        if (sorter != null) {
            this.resort();
        }
    }

    public boolean addActionItem(InternalActionItem actionItem) {
        if (actionItem instanceof InternalActionSet) {
            if (this.actionSetMap.get(actionItem.getName()) != null) {
                return false;
            }
            this.actionSetMap.put(actionItem.getName(), actionItem);
        }
        if (this.sorter != null) {
            int i = 0;
            while (i < this.actionItemList.size()) {
                InternalActionItem currentItem = (InternalActionItem)this.actionItemList.get(i);
                int comp = this.sorter.compare(actionItem, currentItem);
                if (comp < 0) {
                    this.actionItemList.add(i, actionItem);
                    actionItem = null;
                    break;
                }
                ++i;
            }
        }
        if (actionItem != null) {
            this.actionItemList.add(actionItem);
        }
        return true;
    }

    private void resort() {
        ArrayList<InternalActionItem> temp = new ArrayList<InternalActionItem>();
        for (InternalActionItem actionItem : this.actionItemList) {
            int i = 0;
            while (i < temp.size()) {
                InternalActionItem currentItem = (InternalActionItem)temp.get(i);
                if (this.sorter.compare(actionItem, currentItem) < 0) {
                    temp.add(i, actionItem);
                    actionItem = null;
                    break;
                }
                ++i;
            }
            if (actionItem == null) continue;
            temp.add(actionItem);
        }
        this.actionItemList = temp;
    }

    public InternalActionItemContainer findContainer(Stack ids) {
        if (ids.size() == 0) {
            return this;
        }
        String currentId = (String)ids.pop();
        Object obj = this.actionSetMap.get(currentId);
        if (obj == null) {
            return null;
        }
        if (ids.size() > 0) {
            return ((InternalActionSet)obj).findContainer(ids);
        }
        return (InternalActionItemContainer)obj;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getName() {
        return this.name;
    }

    public SectionConstraint getLocation() {
        return this.location;
    }

    public void processSelectionChange(IProvisioningModelSelection selection) {
        int i = 0;
        while (i < this.actionItemList.size()) {
            ((InternalActionItem)this.actionItemList.get(i)).processSelectionChange(selection);
            ++i;
        }
    }

    public void fillContextMenu(IMenuManager menuManager) {
        String groupName = String.valueOf(this.containerId != null && !this.containerId.equals("") ? String.valueOf(this.containerId) + "." : "") + this.name;
        Separator group = new Separator(groupName);
        menuManager.add((IContributionItem)group);
        int i = 0;
        while (i < this.actionItemList.size()) {
            Object obj = this.actionItemList.get(i);
            InternalActionItem iai = (InternalActionItem)obj;
            if (iai.getAvailability() != 0) {
                if (obj instanceof InternalActionSet) {
                    InternalActionSet ias = (InternalActionSet)obj;
                    DynamicMenuManager subMenu = new DynamicMenuManager(ias.getName());
                    if (iai.getAvailability() == 1) {
                        subMenu.setEnabled(false);
                    }
                    subMenu.setParent((IContributionManager)menuManager);
                    menuManager.appendToGroup(groupName, (IContributionItem)subMenu);
                    ias.fillContextMenu((IMenuManager)subMenu);
                } else {
                    final InternalAction ia = (InternalAction)obj;
                    Action action = new Action(ia.getName()){

                        public void run() {
                            ia.performAction(null);
                        }
                    };
                    action.setEnabled(iai.getAvailability() == 2);
                    menuManager.appendToGroup(groupName, (IAction)action);
                }
            }
            ++i;
        }
    }
}

