/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;

public class Brand {
    private String name;
    private Brand parentBrand;
    private List childBrands;
    private BrandManager manager;
    private Map mediaProviders;

    public Brand(String name) {
        this.name = name;
        this.childBrands = new ArrayList();
        this.mediaProviders = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName.equals(this.name)) {
            return;
        }
        String oldName = this.name;
        this.name = newName;
        this.manager.fireBrandNameChanged(this, oldName);
    }

    public Brand getParent() {
        return this.parentBrand;
    }

    public void setParent(Brand brand) {
        if (brand == this.parentBrand) {
            return;
        }
        Brand oldParent = this.parentBrand;
        this.checkParent(brand);
        this.parentBrand = brand;
        this.parentBrand.addChild(this);
        if (oldParent == null) {
            this.manager.fireBrandAdded(this);
        } else {
            this.manager.fireBrandParentChanged(this, oldParent);
        }
    }

    public List getChildBrands() {
        return Collections.unmodifiableList(this.childBrands);
    }

    protected void addChild(Brand child) {
        this.childBrands.remove(child);
        this.childBrands.add(child);
        child.setManager(this.manager);
    }

    protected void removeChild(Brand child) {
        this.childBrands.remove(child);
    }

    private void checkParent(Brand newParent) {
        if (newParent == null) {
            throw new IllegalArgumentException("Parent cannot be null");
        }
        int i = 0;
        while (i < this.childBrands.size()) {
            Brand child = (Brand)this.childBrands.get(i);
            if (child.equals(newParent)) {
                throw new IllegalArgumentException("Circular reference detected in brand structure.");
            }
            child.checkParent(newParent);
            ++i;
        }
    }

    void setManager(BrandManager manager) {
        this.manager = manager;
    }

    public void delete() {
        int i = 0;
        while (i < this.childBrands.size()) {
            Brand child = (Brand)this.childBrands.get(i);
            child.delete();
            ++i;
        }
        this.parentBrand.removeChild(this);
        this.manager.fireBrandRemoved(this);
    }

    public void registerMediaProvider(String interactionType, String languageTag, IMediaProvider mediaProvider) {
        HashMap<String, IMediaProvider> providersByLanguage = (HashMap<String, IMediaProvider>)this.mediaProviders.get(interactionType);
        if (providersByLanguage == null) {
            providersByLanguage = new HashMap<String, IMediaProvider>();
            this.mediaProviders.put(interactionType, providersByLanguage);
        }
        providersByLanguage.put(languageTag, mediaProvider);
    }

    public IMediaProvider getMediaProvider(String interactionType, String languageTag) {
        Map ret = (Map)this.mediaProviders.get(interactionType);
        if (ret == null) {
            if (this.getParent() != null) {
                return this.getParent().getMediaProvider(interactionType, languageTag);
            }
            return null;
        }
        IMediaProvider mp = (IMediaProvider)ret.get(languageTag);
        if (mp == null) {
            if (this.getParent() != null) {
                return this.getParent().getMediaProvider(interactionType, languageTag);
            }
            return null;
        }
        return mp;
    }
}

