/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.osgi.framework.Bundle;

public class ConfigurationManagerRegistry {
    public static final String configurationManagerExtensionId = "org.eclipse.vtp.desktop.core.configurationManagers";
    private static final ConfigurationManagerRegistry instance = new ConfigurationManagerRegistry();
    List managerRecords = new ArrayList();

    public static ConfigurationManagerRegistry getInstance() {
        return instance;
    }

    public ConfigurationManagerRegistry() {
        IConfigurationElement[] managerExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(configurationManagerExtensionId);
        int i = 0;
        while (i < managerExtensions.length) {
            String managerId = managerExtensions[i].getAttribute("id");
            String namespace = managerExtensions[i].getAttribute("xml-namespace");
            String element = managerExtensions[i].getAttribute("xml-tag");
            String className = managerExtensions[i].getAttribute("class");
            Bundle contributor = Platform.getBundle((String)managerExtensions[i].getContributor().getName());
            try {
                Class managerClass = contributor.loadClass(className);
                ConfigurationManagerRecord cmr = new ConfigurationManagerRecord(managerId, namespace, element, managerClass);
                this.managerRecords.add(cmr);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public ConfigurationManager getConfigurationManager(String namespace, String element) {
        int i = 0;
        while (i < this.managerRecords.size()) {
            ConfigurationManagerRecord cmr = (ConfigurationManagerRecord)this.managerRecords.get(i);
            if (cmr.getNamespace().equals(namespace) && cmr.getElement().equals(element)) {
                return cmr.getManagerInstance();
            }
            ++i;
        }
        return null;
    }

    public ConfigurationManager getConfigurationManager(String managerId) {
        int i = 0;
        while (i < this.managerRecords.size()) {
            ConfigurationManagerRecord cmr = (ConfigurationManagerRecord)this.managerRecords.get(i);
            if (cmr.getManagerId().equals(managerId)) {
                return cmr.getManagerInstance();
            }
            ++i;
        }
        return null;
    }

    private class ConfigurationManagerRecord {
        private String managerId;
        private String namespace;
        private String element;
        private Class managerClass;

        public ConfigurationManagerRecord(String managerId, String namespace, String element, Class managerClass) {
            this.managerId = managerId;
            this.namespace = namespace;
            this.element = element;
            this.managerClass = managerClass;
        }

        public String getManagerId() {
            return this.managerId;
        }

        public String getElement() {
            return this.element;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ConfigurationManager getManagerInstance() {
            try {
                return (ConfigurationManager)this.managerClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

