/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.core.configuration.BrandManagerListener;

public class DefaultBrandManager
implements BrandManager {
    private Brand defaultBrand;
    private List listeners = new LinkedList();
    private Map brandMap = new HashMap();
    private Map supportedLanguages = new HashMap();
    private List supportedInteractions = new ArrayList();

    public void fireBrandAdded(Brand brand) {
        this.brandMap.put(brand.getName(), brand);
        for (BrandManagerListener listener : this.listeners) {
            try {
                listener.brandAdded(brand);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void fireBrandNameChanged(Brand brand, String oldName) {
        for (BrandManagerListener listener : this.listeners) {
            try {
                listener.brandNameChanged(brand, oldName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void fireBrandParentChanged(Brand brand, Brand oldParent) {
        for (BrandManagerListener listener : this.listeners) {
            try {
                listener.brandParentChanged(brand, oldParent);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void fireBrandRemoved(Brand brand) {
        this.brandMap.remove(brand.getName());
        for (BrandManagerListener listener : this.listeners) {
            try {
                listener.brandRemoved(brand);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Brand getDefaultBrand() {
        return this.defaultBrand;
    }

    public void setDefaultBrand(Brand defaultBrand) {
        if (this.defaultBrand != null) {
            this.brandMap.remove(this.defaultBrand.getName());
        }
        this.defaultBrand = defaultBrand;
        defaultBrand.setManager(this);
        this.brandMap.put(defaultBrand.getName(), defaultBrand);
    }

    public void addListener(BrandManagerListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(BrandManagerListener listener) {
        this.listeners.remove(listener);
    }

    public boolean checkBrandName(String name) {
        return this.brandMap.get(name) == null;
    }

    public Brand getBrand(String name) {
        return (Brand)this.brandMap.get(name);
    }

    public List getSupportedInteractionTypes() {
        return this.supportedInteractions;
    }

    public void addInteractionSupport(String interactionType) {
        if (!this.supportedInteractions.contains(interactionType)) {
            this.supportedInteractions.add(interactionType);
        }
    }

    public List getSupportedLanguages(String interactionType) {
        ArrayList ret = (ArrayList)this.supportedLanguages.get(interactionType);
        if (ret == null) {
            ret = new ArrayList();
        }
        return ret;
    }

    public void addSupportedLanguage(String interactionType, String language) {
        ArrayList<String> ret = (ArrayList<String>)this.supportedLanguages.get(interactionType);
        if (ret == null) {
            ret = new ArrayList<String>();
            this.supportedLanguages.put(interactionType, ret);
        }
        ret.remove(language);
        ret.add(language);
    }
}

