/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.configuration.attacheddata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.core.configuration.DefaultConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.attacheddata.AttachedDataBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttachedDataManager
extends DefaultConfigurationManager {
    public static final String MEDIA_TYPE_ID = "org.eclipse.vtp.configuration.attacheddata";
    public static final String NAMESPACE_URI = "http://eclipse.org/vtp/xml/configuration/attacheddata";
    private Map bindings = new HashMap();
    private List dataBindings = new ArrayList();

    public AttachedDataBinding getAttachedDataBinding(String name) {
        AttachedDataBinding binding = (AttachedDataBinding)this.bindings.get(name);
        if (binding == null) {
            binding = new AttachedDataBinding(this, name);
            this.bindings.put(name, binding);
            this.dataBindings.add(binding);
        }
        return binding;
    }

    public List listBindings() {
        ArrayList ret = new ArrayList(this.dataBindings.size());
        ret.addAll(this.dataBindings);
        return ret;
    }

    public List listPromptBindings() {
        return Collections.unmodifiableList(this.dataBindings);
    }

    public String getType() {
        return MEDIA_TYPE_ID;
    }

    public void readConfiguration(Element configuration) {
        super.readConfiguration(configuration);
        System.out.println(configuration);
        NodeList bindingList = configuration.getElementsByTagNameNS(NAMESPACE_URI, "attached-data-binding");
        int i = 0;
        while (i < bindingList.getLength()) {
            Element bindingElement = (Element)bindingList.item(i);
            AttachedDataBinding binding = this.getAttachedDataBinding(bindingElement.getAttribute("name"));
            binding.readBindingItems(bindingElement);
            ++i;
        }
    }

    public void writeConfiguration(Element configuration) {
        Element bindingsElement = configuration.getOwnerDocument().createElementNS(NAMESPACE_URI, "bindings");
        for (AttachedDataBinding binding : this.dataBindings) {
            Element bindingElement = configuration.getOwnerDocument().createElementNS(NAMESPACE_URI, "attached-data-binding");
            bindingElement.setAttribute("name", binding.getName());
            binding.writeBindingItems(bindingElement);
            bindingsElement.appendChild(bindingElement);
        }
        configuration.appendChild(bindingsElement);
    }

    public Object clone() {
        AttachedDataManager copy = new AttachedDataManager();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "temporary-document", null);
            Element rootElement = document.getDocumentElement();
            this.writeConfiguration(rootElement);
            NodeList bindingList = rootElement.getElementsByTagNameNS(NAMESPACE_URI, "bindings");
            if (bindingList.getLength() > 0) {
                copy.readConfiguration((Element)bindingList.item(0));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        copy.setBrandManager(this.getBrandManager());
        return copy;
    }
}

