/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.configuration.media;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.media.BindingItem;
import org.eclipse.vtp.desktop.core.configuration.media.MediaBindingManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class MediaBinding {
    public static final String NAMESPACE_URI = "http://eclipse.org/vtp/xml/configuration/media";
    private String name;
    private MediaBindingManager manager = null;
    private Map bindingItems = new HashMap();

    public MediaBinding(MediaBindingManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MediaBindingManager getMediaBindingManager() {
        return this.manager;
    }

    protected BindingItem getItem(String brand, String interactionType, String language) {
        Brand brandObject = this.manager.getBrandManager().getBrand(brand);
        BindingItem bindingItemObject = (BindingItem)this.bindingItems.get(String.valueOf(brand) + interactionType + language);
        while (bindingItemObject == null && brandObject.getParent() != null) {
            bindingItemObject = (BindingItem)this.bindingItems.get(String.valueOf((brandObject = brandObject.getParent()).getName()) + interactionType + language);
            if (bindingItemObject == null) continue;
            bindingItemObject = (BindingItem)bindingItemObject.clone();
        }
        return bindingItemObject;
    }

    protected void putItem(String brand, String interactionType, String language, BindingItem item) {
        this.bindingItems.put(String.valueOf(brand) + interactionType + language, item);
        Brand brandObject = this.manager.getBrandManager().getBrand(brand);
        while (brandObject.getParent() != null) {
            if (this.bindingItems.get(String.valueOf((brandObject = brandObject.getParent()).getName()) + interactionType + language) != null) break;
            this.bindingItems.put(String.valueOf(brandObject.getName()) + interactionType + language, item);
        }
    }

    public void readBindingItems(Element bindingConfiguration) {
        NodeList itemList = bindingConfiguration.getElementsByTagNameNS(NAMESPACE_URI, "item");
        int i = 0;
        while (i < itemList.getLength()) {
            Element itemElement = (Element)itemList.item(i);
            this.bindingItems.put(itemElement.getAttribute("key"), this.readBindingItem(itemElement));
            ++i;
        }
    }

    public void writeBindingItems(Element bindingConfiguration) {
        for (Map.Entry entry : this.bindingItems.entrySet()) {
            System.out.println("Writing entry: " + entry);
            Element itemElement = bindingConfiguration.getOwnerDocument().createElementNS(NAMESPACE_URI, "item");
            bindingConfiguration.appendChild(itemElement);
            itemElement.setAttribute("key", (String)entry.getKey());
            this.writeBindingItem((BindingItem)entry.getValue(), itemElement);
        }
    }

    protected abstract BindingItem readBindingItem(Element var1);

    protected abstract void writeBindingItem(BindingItem var1, Element var2);
}

