/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.configuration.media;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.vtp.desktop.core.configuration.DefaultConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.media.GrammarMediaBinding;
import org.eclipse.vtp.desktop.core.configuration.media.MediaBinding;
import org.eclipse.vtp.desktop.core.configuration.media.PromptMediaBinding;
import org.eclipse.vtp.desktop.core.configuration.media.PropertyMediaBinding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MediaBindingManager
extends DefaultConfigurationManager {
    public static final String MEDIA_TYPE_ID = "org.eclipse.vtp.configuration.media";
    public static final String NAMESPACE_URI = "http://eclipse.org/vtp/xml/configuration/media";
    private Map bindings = new HashMap();
    private List promptBindings = new ArrayList();
    private List grammarBindings = new ArrayList();
    private List propertyBindings = new ArrayList();

    public PromptMediaBinding getPromptBinding(String name) {
        PromptMediaBinding binding = (PromptMediaBinding)this.bindings.get(name);
        if (binding == null) {
            binding = new PromptMediaBinding(this, name);
            this.bindings.put(name, binding);
            this.promptBindings.add(binding);
        }
        return binding;
    }

    public GrammarMediaBinding getGrammarBinding(String name) {
        GrammarMediaBinding binding = (GrammarMediaBinding)this.bindings.get(name);
        if (binding == null) {
            binding = new GrammarMediaBinding(this, name);
            this.bindings.put(name, binding);
            this.grammarBindings.add(binding);
        }
        return binding;
    }

    public PropertyMediaBinding getPropertyBinding(String name) {
        PropertyMediaBinding binding = (PropertyMediaBinding)this.bindings.get(name);
        if (binding == null) {
            binding = new PropertyMediaBinding(this, name);
            this.bindings.put(name, binding);
            this.propertyBindings.add(binding);
        }
        return binding;
    }

    public List listBindings() {
        ArrayList ret = new ArrayList(this.promptBindings.size() + this.grammarBindings.size() + this.propertyBindings.size());
        ret.addAll(this.promptBindings);
        ret.addAll(this.grammarBindings);
        ret.addAll(this.propertyBindings);
        return ret;
    }

    public List listPromptBindings() {
        return Collections.unmodifiableList(this.promptBindings);
    }

    public List listGrammarBindings() {
        return Collections.unmodifiableList(this.grammarBindings);
    }

    public List listPropertyBindings() {
        return Collections.unmodifiableList(this.propertyBindings);
    }

    public String getType() {
        return MEDIA_TYPE_ID;
    }

    public void readConfiguration(Element configuration) {
        MediaBinding binding;
        Element bindingElement;
        super.readConfiguration(configuration);
        System.out.println(configuration);
        NodeList bindingList = configuration.getElementsByTagNameNS(NAMESPACE_URI, "prompt-binding");
        int i = 0;
        while (i < bindingList.getLength()) {
            bindingElement = (Element)bindingList.item(i);
            binding = this.getPromptBinding(bindingElement.getAttribute("name"));
            binding.readBindingItems(bindingElement);
            ++i;
        }
        bindingList = configuration.getElementsByTagNameNS(NAMESPACE_URI, "grammar-binding");
        i = 0;
        while (i < bindingList.getLength()) {
            bindingElement = (Element)bindingList.item(i);
            binding = this.getGrammarBinding(bindingElement.getAttribute("name"));
            binding.readBindingItems(bindingElement);
            ++i;
        }
        bindingList = configuration.getElementsByTagNameNS(NAMESPACE_URI, "property-binding");
        i = 0;
        while (i < bindingList.getLength()) {
            bindingElement = (Element)bindingList.item(i);
            binding = this.getPropertyBinding(bindingElement.getAttribute("name"));
            binding.readBindingItems(bindingElement);
            ++i;
        }
    }

    public void writeConfiguration(Element configuration) {
        Element bindingElement;
        Element bindingsElement = configuration.getOwnerDocument().createElementNS(NAMESPACE_URI, "bindings");
        for (MediaBinding binding : this.promptBindings) {
            bindingElement = configuration.getOwnerDocument().createElementNS(NAMESPACE_URI, "prompt-binding");
            bindingElement.setAttribute("name", binding.getName());
            binding.writeBindingItems(bindingElement);
            bindingsElement.appendChild(bindingElement);
        }
        for (MediaBinding binding : this.grammarBindings) {
            bindingElement = configuration.getOwnerDocument().createElementNS(NAMESPACE_URI, "grammar-binding");
            bindingElement.setAttribute("name", binding.getName());
            binding.writeBindingItems(bindingElement);
            bindingsElement.appendChild(bindingElement);
        }
        for (MediaBinding binding : this.propertyBindings) {
            bindingElement = configuration.getOwnerDocument().createElementNS(NAMESPACE_URI, "property-binding");
            bindingElement.setAttribute("name", binding.getName());
            binding.writeBindingItems(bindingElement);
            bindingsElement.appendChild(bindingElement);
        }
        configuration.appendChild(bindingsElement);
    }

    public Object clone() {
        MediaBindingManager copy = new MediaBindingManager();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.getDOMImplementation().createDocument(null, "temporary-document", null);
            Element rootElement = document.getDocumentElement();
            this.writeConfiguration(rootElement);
            NodeList bindingList = rootElement.getElementsByTagNameNS(NAMESPACE_URI, "bindings");
            if (bindingList.getLength() > 0) {
                copy.readConfiguration((Element)bindingList.item(0));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        copy.setBrandManager(this.getBrandManager());
        return copy;
    }
}

