/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FramedDialog
extends Window {
    Color contentBackground;
    Color frameColor;
    Color sideBarColor;
    Control sideBarControl;
    Control contentControl;
    Control buttonBarControl;
    Composite frameComposite;
    int sideBarSize = 10;
    String title;

    public FramedDialog(Shell parentShell) {
        this((IShellProvider)new SameShellProvider((Control)parentShell));
        if (parentShell == null && Policy.DEBUG_DIALOG_NO_PARENT) {
            Policy.getLog().log((IStatus)new Status(1, "org.eclipse.jface", 1, ((Object)((Object)this)).getClass() + " created with no shell", (Throwable)new Exception()));
        }
    }

    public FramedDialog(IShellProvider shellProvider) {
        super(shellProvider);
        this.setShellStyle(0x10870 | FramedDialog.getDefaultOrientation());
        this.setBlockOnOpen(true);
        this.contentBackground = shellProvider.getShell().getDisplay().getSystemColor(1);
        this.frameColor = shellProvider.getShell().getDisplay().getSystemColor(16);
        this.sideBarColor = shellProvider.getShell().getDisplay().getSystemColor(15);
    }

    protected Control createContents(Composite parent) {
        this.frameComposite = new Composite(parent, 0x20040000);
        this.frameComposite.setLayoutData((Object)new GridData(1808));
        this.frameComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC g = e.gc;
                g.setAntialias(1);
                g.setBackground(FramedDialog.this.contentBackground);
                g.fillRectangle(0, 0, FramedDialog.this.frameComposite.getSize().x, FramedDialog.this.frameComposite.getSize().y);
                g.setBackground(FramedDialog.this.frameColor);
                g.fillRectangle(0, 0, FramedDialog.this.frameComposite.getSize().x, 30);
                g.fillRectangle(0, FramedDialog.this.frameComposite.getSize().y - 10, FramedDialog.this.frameComposite.getSize().x, 10);
                g.fillRectangle(0, 30, FramedDialog.this.sideBarSize, FramedDialog.this.frameComposite.getSize().y - 35);
                g.fillRectangle(FramedDialog.this.sideBarSize, 30, FramedDialog.this.contentControl.getLocation().x - FramedDialog.this.sideBarSize, 20);
                g.fillRectangle(FramedDialog.this.sideBarSize, FramedDialog.this.frameComposite.getSize().y - 30, FramedDialog.this.contentControl.getLocation().x - FramedDialog.this.sideBarSize, 20);
                g.setBackground(FramedDialog.this.contentBackground);
                g.fillArc(FramedDialog.this.sideBarSize, 30, (FramedDialog.this.contentControl.getLocation().x - FramedDialog.this.sideBarSize) * 2, 40, 180, -90);
                g.fillArc(FramedDialog.this.sideBarSize, FramedDialog.this.frameComposite.getSize().y - 50, (FramedDialog.this.contentControl.getLocation().x - FramedDialog.this.sideBarSize) * 2, 40, 180, 90);
            }
        });
        this.frameComposite.setLayout((Layout)new FormLayout());
        this.buttonBarControl = new Composite(this.frameComposite, 0);
        this.buttonBarControl.setBackground(this.contentBackground);
        FormData buttonBarControlData = new FormData();
        buttonBarControlData.left = new FormAttachment(0, this.sideBarSize + 30);
        buttonBarControlData.bottom = new FormAttachment(100, -10);
        buttonBarControlData.right = new FormAttachment(100, 0);
        this.buttonBarControl.setLayoutData((Object)buttonBarControlData);
        this.createButtonBar((Composite)this.buttonBarControl);
        this.sideBarControl = new Composite(this.frameComposite, 0);
        this.sideBarControl.setBackground(this.sideBarColor);
        FormData sideBarControlData = new FormData();
        sideBarControlData.left = new FormAttachment(0);
        sideBarControlData.top = new FormAttachment(0, 50);
        sideBarControlData.right = new FormAttachment(this.buttonBarControl, -30);
        sideBarControlData.bottom = new FormAttachment(100, -30);
        this.sideBarControl.setLayoutData((Object)sideBarControlData);
        this.createSideBar((Composite)this.sideBarControl);
        this.contentControl = new Composite(this.frameComposite, 0);
        this.contentControl.setBackground(this.contentBackground);
        FormData contentControlData = new FormData();
        contentControlData.left = new FormAttachment(this.sideBarControl, 30);
        contentControlData.top = new FormAttachment(0, 30);
        contentControlData.right = new FormAttachment(100, 0);
        contentControlData.bottom = new FormAttachment(this.buttonBarControl, 0);
        this.contentControl.setLayoutData((Object)contentControlData);
        this.createDialogContents((Composite)this.contentControl);
        return this.frameComposite;
    }

    protected void createButtonBar(Composite parent) {
        FormData data = (FormData)parent.getLayoutData();
        data.height = 30;
    }

    protected void createSideBar(Composite parent) {
    }

    protected void createDialogContents(Composite parent) {
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    public Color getSideBarColor() {
        return this.sideBarColor;
    }

    public void setSideBarColor(Color sideBarColor) {
        this.sideBarColor = sideBarColor;
        if (this.sideBarControl != null) {
            this.sideBarControl.setBackground(sideBarColor);
        }
    }

    public Control getSideBarControl() {
        return this.sideBarControl;
    }

    public void setSideBarControl(Control sideBarControl) {
        this.sideBarControl = sideBarControl;
    }

    public int getSideBarSize() {
        return this.sideBarSize;
    }

    public void setSideBarSize(int sideBarSize) {
        this.sideBarSize = sideBarSize;
        if (this.buttonBarControl != null) {
            FormData data = (FormData)this.buttonBarControl.getLayoutData();
            data.left.offset = sideBarSize + 40;
            this.frameComposite.layout(true, true);
            this.frameComposite.redraw();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String string = this.title = title == null ? "" : title;
        if (this.getShell() != null) {
            this.getShell().setText(title);
        }
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
    }

    public Shell getParentShell() {
        return super.getParentShell();
    }
}

