/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.core.custom.LinkViewerSelectionListener;
import org.eclipse.vtp.desktop.core.custom.TextLinkViewer;
import org.eclipse.vtp.desktop.core.dialogs.ContentPage;
import org.eclipse.vtp.desktop.core.dialogs.FramedDialog;

public class MultiPageFramedDialog
extends FramedDialog
implements LinkViewerSelectionListener {
    TextLinkViewer linkViewer;
    List pages = new ArrayList();
    StackLayout stackLayout;
    Map pageControls = new HashMap();
    Button okButton = null;

    public MultiPageFramedDialog(Shell parentShell) {
        super(parentShell);
        this.init();
    }

    public MultiPageFramedDialog(IShellProvider shellProvider) {
        super(shellProvider);
        this.init();
    }

    private void init() {
        this.setSideBarSize(110);
    }

    protected void createButtonBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite buttons = new Composite(parent, 0);
        buttons.setBackground(parent.getBackground());
        GridData buttonsData = new GridData(1808);
        buttonsData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)buttonsData);
        RowLayout rl = new RowLayout();
        rl.pack = false;
        rl.spacing = 5;
        buttons.setLayout((Layout)rl);
        this.okButton = new Button(buttons, 0);
        this.okButton.setText("Ok");
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MultiPageFramedDialog.this.okPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button cancelButton = new Button(buttons, 0);
        cancelButton.setText("Cancel");
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MultiPageFramedDialog.this.cancelPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createDialogContents(Composite parent) {
        this.stackLayout = new StackLayout();
        parent.setLayout((Layout)this.stackLayout);
        int i = 0;
        while (i < this.pages.size()) {
            ContentPage p = (ContentPage)this.pages.get(i);
            Control c = p.createPage(parent);
            this.pageControls.put(p.getName(), c);
            if (i == 0) {
                this.stackLayout.topControl = c;
            }
            ++i;
        }
    }

    protected void createSideBar(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.linkViewer = new TextLinkViewer(parent, 0);
        int i = 0;
        while (i < this.pages.size()) {
            this.linkViewer.addLink(((ContentPage)this.pages.get(i)).getName());
            ++i;
        }
        this.linkViewer.addSelectionListener(this);
    }

    public void addPage(ContentPage page) {
        this.pages.add(page);
        page.setRootShell(this.getParentShell());
    }

    protected void cancelPressed() {
        this.setReturnCode(256);
        this.close();
    }

    protected boolean processOk() {
        return true;
    }

    protected void okPressed() {
        if (this.processOk()) {
            this.setReturnCode(0);
            this.close();
        }
    }

    protected List getPages() {
        return this.pages;
    }

    public void selectionChanged(String selection) {
        this.stackLayout.topControl = (Control)this.pageControls.get(selection);
        this.stackLayout.topControl.getParent().layout();
    }

    public void setCanFinish(boolean canFinish) {
        if (this.okButton != null) {
            this.okButton.setEnabled(canFinish);
        }
    }
}

