/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.core.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddDesignCanvasWizard
extends Wizard {
    ApplicationPage page = null;
    String[] currentNames;
    private String canvasName;

    public AddDesignCanvasWizard(String[] currentNames) {
        this.currentNames = currentNames;
        this.page = new ApplicationPage();
        this.addPage((IWizardPage)this.page);
    }

    public String getCanvasName() {
        return this.canvasName;
    }

    public boolean performFinish() {
        this.canvasName = this.page.getApplicationName();
        return true;
    }

    private class ApplicationPage
    extends WizardPage {
        private Text nameField;

        public ApplicationPage() {
            super("CreateDesignCanvasPage", "New Design Canvas", null);
            this.nameField = null;
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            this.setControl((Control)parent);
            Label hostLabel = new Label(parent, 0);
            hostLabel.setText("Design Canvas Name:");
            hostLabel.setSize(hostLabel.computeSize(-1, -1));
            this.nameField = new Text(parent, 2052);
            this.nameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    boolean found = false;
                    int i = 0;
                    while (i < ((ApplicationPage)ApplicationPage.this).AddDesignCanvasWizard.this.currentNames.length) {
                        if (((ApplicationPage)ApplicationPage.this).AddDesignCanvasWizard.this.currentNames[i].equalsIgnoreCase(ApplicationPage.this.nameField.getText())) {
                            ApplicationPage.this.setErrorMessage("A design canvas with that name already exists.");
                            ApplicationPage.this.setPageComplete(false);
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        ApplicationPage.this.setErrorMessage(null);
                        ApplicationPage.this.setPageComplete(true);
                    }
                }
            });
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 10;
            formLayout.marginWidth = 10;
            parent.setLayout((Layout)formLayout);
            FormData hostLabelFormData = new FormData();
            hostLabelFormData.left = new FormAttachment(0, 10);
            hostLabelFormData.top = new FormAttachment(0, 10);
            hostLabelFormData.right = new FormAttachment(0, 10 + hostLabel.getSize().x);
            hostLabelFormData.bottom = new FormAttachment(0, 10 + hostLabel.getSize().y);
            hostLabel.setLayoutData((Object)hostLabelFormData);
            FormData hostFieldFormData = new FormData();
            hostFieldFormData.left = new FormAttachment((Control)hostLabel, 6);
            hostFieldFormData.top = new FormAttachment(0, 10);
            hostFieldFormData.right = new FormAttachment(100, -10);
            this.nameField.setLayoutData((Object)hostFieldFormData);
        }

        public String getApplicationName() {
            return this.nameField.getText();
        }
    }
}

