/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.media;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.framework.interactions.core.media.IInputGrammarFactory;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class InputLoadingManager
implements IInputGrammarFactory {
    public static final String inputTypeExtensionId = "org.eclipse.vtp.framework.interactions.core.inputtypes";
    private static final InputLoadingManager instance = new InputLoadingManager();
    private Map inputTypes = new HashMap();
    private Map inputTypesById = new HashMap();

    public static InputLoadingManager getInstance() {
        return instance;
    }

    public InputLoadingManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(inputTypeExtensionId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            String inputElementURI = primitiveExtensions[i].getAttribute("element-uri");
            String inputElementName = primitiveExtensions[i].getAttribute("element-name");
            String inputClassName = primitiveExtensions[i].getAttribute("class");
            if (inputElementURI != null && inputElementName != null && inputClassName != null) {
                Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
                try {
                    Class providerClass = contributor.loadClass(inputClassName);
                    if (InputGrammar.class.isAssignableFrom(providerClass)) {
                        InputRegistration reg = new InputRegistration();
                        reg.id = primitiveExtensions[i].getAttribute("id");
                        reg.inputElementURI = inputElementURI;
                        reg.inputElementName = inputElementName;
                        reg.inputClass = providerClass;
                        this.inputTypes.put(String.valueOf(inputElementURI) + inputElementName, reg);
                        this.inputTypesById.put(reg.id, reg);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public InputGrammar loadInput(Element inputElement) {
        InputRegistration reg;
        block5: {
            try {
                String uri = inputElement.getNamespaceURI();
                String name = inputElement.getTagName();
                reg = (InputRegistration)this.inputTypes.get(String.valueOf(uri) + name);
                if (reg != null) break block5;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            return (InputGrammar)reg.inputClass.getConstructor(IInputGrammarFactory.class, Element.class).newInstance(this, inputElement);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (InputGrammar)reg.inputClass.getConstructor(Element.class).newInstance(inputElement);
        }
    }

    private class InputRegistration {
        String id;
        String inputElementURI;
        String inputElementName;
        Class inputClass;

        private InputRegistration() {
        }
    }
}

