/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.vtp.desktop.media.core.ContentEntryDialog;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FileContent;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.ReferencedContent;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;

public abstract class ContentDialog
extends Dialog {
    protected final List contents = new ArrayList();
    private IMediaProvider mediaProvider = null;
    private TableViewer viewer = null;

    public ContentDialog(Shell parentShell) {
        super(parentShell);
    }

    public ContentDialog(IShellProvider parentShellProvider) {
        super(parentShellProvider);
    }

    public void setMediaProvider(IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    protected void contentChanged() {
        this.getButton(0).setEnabled(this.isContentValid());
    }

    protected boolean isContentValid() {
        return true;
    }

    protected List getVariables() {
        return null;
    }

    protected Control createContents(Composite parent) {
        Control createdContents = super.createContents(parent);
        this.contentChanged();
        return createdContents;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Contents");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData());
        Table table = new Table(comp, 68100);
        table.setHeaderVisible(true);
        GridData gd = new GridData();
        gd.widthHint = 255;
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        TableColumn entryColumn = new TableColumn(table, 0);
        entryColumn.setText("Entries");
        entryColumn.setWidth(250);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new PromptBindingContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PromptBindingLabelProvider());
        this.viewer.setInput((Object)this);
        Composite buttonComp = new Composite(comp, 0);
        buttonComp.setLayout((Layout)new GridLayout());
        gd = new GridData();
        gd.verticalIndent = 20;
        gd.verticalAlignment = 128;
        buttonComp.setLayoutData((Object)gd);
        Button addButton = new Button(buttonComp, 8);
        addButton.setText("Add Entry");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    ContentEntryDialog pbed = new ContentEntryDialog(ContentDialog.this.getShell());
                    pbed.setMediaProvider(ContentDialog.this.mediaProvider);
                    pbed.setVariables(ContentDialog.this.getVariables());
                    int result = pbed.open();
                    if (result == 0) {
                        Content c = pbed.getContent();
                        ContentDialog.this.contents.add(c);
                        ContentDialog.this.viewer.refresh();
                        ContentDialog.this.contentChanged();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        final Button editButton = new Button(buttonComp, 8);
        editButton.setText("Edit Entry");
        editButton.setEnabled(false);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    ContentEntryDialog pbed = new ContentEntryDialog(ContentDialog.this.getShell());
                    pbed.setMediaProvider(ContentDialog.this.mediaProvider);
                    pbed.setVariables(ContentDialog.this.getVariables());
                    IStructuredSelection selection = (IStructuredSelection)ContentDialog.this.viewer.getSelection();
                    pbed.setContent((Content)selection.getFirstElement());
                    int result = pbed.open();
                    if (result == 0) {
                        Content c = pbed.getContent();
                        int idex = ContentDialog.this.contents.indexOf(selection.getFirstElement());
                        ContentDialog.this.contents.remove(idex);
                        ContentDialog.this.contents.add(idex, c);
                        ContentDialog.this.viewer.refresh();
                        ContentDialog.this.contentChanged();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        final Button removeButton = new Button(buttonComp, 8);
        removeButton.setText("Remove Entry");
        removeButton.setEnabled(false);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    IStructuredSelection selection = (IStructuredSelection)ContentDialog.this.viewer.getSelection();
                    ContentDialog.this.contents.remove(selection.getFirstElement());
                    ContentDialog.this.viewer.refresh();
                    ContentDialog.this.contentChanged();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                editButton.setEnabled(!selection.isEmpty());
                removeButton.setEnabled(!selection.isEmpty());
            }
        });
        return comp;
    }

    private class PromptBindingContentProvider
    implements IStructuredContentProvider {
        private PromptBindingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ContentDialog.this.contents.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PromptBindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PromptBindingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            StringBuffer buf = new StringBuffer();
            Content content = (Content)element;
            if (content instanceof FormattableContent) {
                FormattableContent fc = (FormattableContent)content;
                buf.append(String.valueOf(fc.getContentTypeName()) + "(" + fc.getFormatName() + ", " + fc.getValue() + ")");
            } else if (content instanceof TextContent) {
                buf.append(((TextContent)content).getText());
            } else if (content instanceof ReferencedContent) {
                buf.append("REFERENCE(" + ((ReferencedContent)content).getReferencedName() + ")");
            } else if (content instanceof FileContent) {
                FileContent fc = (FileContent)content;
                buf.append(String.valueOf(fc.getFileTypeName()) + "(" + fc.getPath() + ")");
            }
            return buf.toString();
        }
    }
}

