/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.media.core.ContentCreatorPanel;
import org.eclipse.vtp.desktop.media.core.ContentCreatorPanelManager;
import org.eclipse.vtp.desktop.media.core.DynamicContentCreatorPanel;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.media.ContentType;

public class ContentEntryDialog
extends Dialog {
    private IMediaProvider mediaProvider = null;
    List supportedTypes;
    List variables;
    List creatorControls = new ArrayList();
    StackLayout stackLayout;
    Combo typeCombo = null;
    Content content;
    Composite creatorComp;

    public ContentEntryDialog(Shell parentShell) {
        super(parentShell);
    }

    public ContentEntryDialog(IShellProvider parentShellProvider) {
        super(parentShellProvider);
    }

    public void setVariables(List variables) {
        this.variables = variables;
    }

    public void setMediaProvider(IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Prompt Entry");
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Label typeLabel = new Label(comp, 0);
        typeLabel.setText("Content Type");
        typeLabel.setLayoutData((Object)new GridData());
        this.typeCombo = new Combo(comp, 12);
        this.typeCombo.setLayoutData((Object)new GridData(768));
        this.supportedTypes = this.mediaProvider.getSupportedContentTypes();
        this.creatorComp = new Composite(comp, 0);
        this.creatorComp.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.creatorComp.setLayout((Layout)this.stackLayout);
        int i = 0;
        while (i < this.supportedTypes.size()) {
            ContentType ct = (ContentType)this.supportedTypes.get(i);
            this.typeCombo.add(ct.getName());
            ContentCreatorPanel ccp = ContentCreatorPanelManager.getInstance().getCreatorPanel(ct);
            ccp.setMediaProvider(this.mediaProvider);
            if (ccp instanceof DynamicContentCreatorPanel) {
                ((DynamicContentCreatorPanel)ccp).setVariables(this.variables);
            }
            this.creatorControls.add(ccp);
            ccp.createControls(this.creatorComp);
            if (this.content != null && this.content.getContentType().equals(ct.getId())) {
                this.typeCombo.select(i);
                this.stackLayout.topControl = ccp.getControl();
                ccp.setInitialContent(this.content);
            }
            ++i;
        }
        if (this.content == null) {
            this.stackLayout.topControl = ((ContentCreatorPanel)this.creatorControls.get(0)).getControl();
            this.typeCombo.select(0);
        }
        this.typeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ContentEntryDialog.this.stackLayout.topControl = ((ContentCreatorPanel)ContentEntryDialog.this.creatorControls.get(ContentEntryDialog.this.typeCombo.getSelectionIndex())).getControl();
                ContentEntryDialog.this.creatorComp.layout(true, true);
            }
        });
        return comp;
    }

    protected void okPressed() {
        ContentCreatorPanel ccp = (ContentCreatorPanel)this.creatorControls.get(this.typeCombo.getSelectionIndex());
        this.content = ccp.createContent();
        super.okPressed();
    }

    public Content getContent() {
        return this.content;
    }

    public void setContent(Content content) {
        this.content = content;
    }
}

