/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.media.core.DynamicContentCreatorPanel;
import org.eclipse.vtp.desktop.media.core.ResourceChooserDialog;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FileContent;

public abstract class FileContentCreatorPanel
extends DynamicContentCreatorPanel
implements SelectionListener {
    Text text = null;

    public Content createContent() {
        FileContent content = this.createNewContent();
        if (this.isDynamicSelected()) {
            content.setVariablePath(this.getDynamicSelection());
        } else {
            content.setStaticPath(this.text.getText());
        }
        return content;
    }

    public Control createStaticControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.text = new Text(comp, 0x800804);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.setEditable(false);
        Button browseButton = new Button(comp, 8);
        browseButton.setText("Browse...");
        browseButton.setLayoutData((Object)new GridData());
        browseButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    public void setInitialContent(Content content) {
        if (content instanceof FileContent) {
            FileContent fileContent = (FileContent)content;
            if (fileContent.getPathType() == 1) {
                this.setDynamicSelected(false);
                this.text.setText(fileContent.getPath());
            } else {
                this.setDynamicSelected(true);
                this.setDynamicSelection(fileContent.getPath());
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        ResourceChooserDialog dialog = new ResourceChooserDialog(this.text.getShell(), this.getMediaProvider().getResourceManager(), this.text.getText());
        if (dialog.open() != 0) {
            return;
        }
        this.text.setText(dialog.getValue());
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected abstract FileContent createNewContent();
}

