/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.media.GrammarBindingItem;
import org.eclipse.vtp.desktop.core.configuration.media.GrammarMediaBinding;
import org.eclipse.vtp.desktop.media.core.GrammarEntryDialog;
import org.eclipse.vtp.framework.interactions.core.media.InputGrammar;

public class GrammarBindingViewer
implements MouseListener {
    GrammarMediaBinding grammarBinding;
    Brand currentBrand;
    String currentLanguage;
    Label contents;
    String interactionType;

    public GrammarBindingViewer(GrammarMediaBinding grammarBinding, String interactionType) {
        this.grammarBinding = grammarBinding;
        this.interactionType = interactionType;
    }

    public void createControls(Composite parent) {
        this.contents = new Label(parent, 64);
        this.contents.setBackground(parent.getBackground());
        this.contents.setText("Not Configured");
        this.contents.addMouseListener((MouseListener)this);
    }

    public Control getControl() {
        return this.contents;
    }

    public void setCurrentBrand(Brand brand) {
        System.out.println("new brand: " + brand.getName());
        this.currentBrand = brand;
        if (this.currentLanguage != null) {
            this.setContents();
        }
    }

    private void setContents() {
        GrammarBindingItem pbi = this.grammarBinding.getGrammarItem(this.currentBrand.getName(), this.interactionType, this.currentLanguage);
        this.contents.setText(pbi.getGrammar() == null ? "Not Configured" : pbi.getGrammar().toString());
    }

    public void setCurrentLanguage(String language) {
        this.currentLanguage = language;
        if (this.currentBrand != null) {
            this.setContents();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        try {
            System.out.println("mouse double click");
            Shell workbenchShell = Display.getCurrent().getActiveShell();
            GrammarEntryDialog pbd = new GrammarEntryDialog(workbenchShell);
            GrammarBindingItem pbi = this.grammarBinding.getGrammarItem(this.currentBrand.getName(), this.interactionType, this.currentLanguage);
            System.out.println("Media Provider in Grammar viwer: " + this.currentBrand.getMediaProvider(this.interactionType, this.currentLanguage));
            System.out.println("Interaction type in Grammar viwer: " + this.interactionType);
            System.out.println("Language in Grammar viwer: " + this.currentLanguage);
            pbd.setMediaProvider(this.currentBrand.getMediaProvider(this.interactionType, this.currentLanguage));
            pbd.setContent(pbi.getGrammar());
            int result = pbd.open();
            if (result == 0) {
                System.out.println("is ok");
                InputGrammar gram = pbd.getContent();
                pbi.setGrammar(gram);
                System.out.println("set grammar to: " + gram);
                this.grammarBinding.putGrammarItem(this.currentBrand.getName(), this.interactionType, this.currentLanguage, pbi);
                this.setContents();
                Composite comp = this.contents.getParent();
                while (comp.getParent() != null && comp.getParent().getLayout() != null && comp.getParent().getLayout() instanceof GridLayout) {
                    comp = comp.getParent();
                }
                comp.layout(true, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }
}

