/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.media.core.InputGrammarCreatorPanel;
import org.eclipse.vtp.framework.media.InputType;
import org.osgi.framework.Bundle;

public class InputGrammarCreatorPanelManager {
    public static final String inputCreatorPanelExtensionId = "org.eclipse.vtp.desktop.media.core.inputCreatorPanels";
    private static final InputGrammarCreatorPanelManager INSTANCE = new InputGrammarCreatorPanelManager();
    Map creatorPanels = new HashMap();

    public static InputGrammarCreatorPanelManager getInstance() {
        return INSTANCE;
    }

    public InputGrammarCreatorPanelManager() {
        IConfigurationElement[] creatorExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(inputCreatorPanelExtensionId);
        int i = 0;
        while (i < creatorExtensions.length) {
            block3: {
                ContentCreatorRecord ccr = new ContentCreatorRecord();
                ccr.contentType = creatorExtensions[i].getAttribute("input-type");
                ccr.contentName = creatorExtensions[i].getAttribute("input-type-name");
                String className = creatorExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)creatorExtensions[i].getContributor().getName());
                try {
                    ccr.creatorClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block3;
                }
                System.out.println("Input Type: " + ccr.contentType);
                this.creatorPanels.put(ccr.contentType, ccr);
            }
            ++i;
        }
    }

    public List getInputTypes() {
        ArrayList ret = new ArrayList();
        Iterator i = this.creatorPanels.values().iterator();
        while (i.hasNext()) {
            ret.add(i.next());
        }
        return ret;
    }

    public InputGrammarCreatorPanel getCreatorPanel(InputType contentType) {
        ContentCreatorRecord ccr = (ContentCreatorRecord)this.creatorPanels.get(contentType.getId());
        if (ccr != null) {
            try {
                return (InputGrammarCreatorPanel)ccr.creatorClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public class ContentCreatorRecord {
        String contentType;
        String contentName;
        Class creatorClass;
    }
}

