/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.media.core.MediaConfigurationScreen;
import org.eclipse.vtp.desktop.model.core.Element;
import org.osgi.framework.Bundle;

public class MediaConfigurationScreenManager {
    public static final String mediaConfigurationScreenExtensionId = "org.eclipse.vtp.desktop.media.core.mediaConfigurationScreens";
    private static final MediaConfigurationScreenManager INSTANCE = new MediaConfigurationScreenManager();
    Map configurationScreens = new HashMap();

    public static MediaConfigurationScreenManager getInstance() {
        return INSTANCE;
    }

    public MediaConfigurationScreenManager() {
        IConfigurationElement[] screenExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(mediaConfigurationScreenExtensionId);
        int i = 0;
        while (i < screenExtensions.length) {
            block4: {
                ConfigurationScreenRecord csr = new ConfigurationScreenRecord();
                csr.primitiveTypeId = screenExtensions[i].getAttribute("primitive-id");
                csr.interactionType = screenExtensions[i].getAttribute("interaction-type");
                String className = screenExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)screenExtensions[i].getContributor().getName());
                try {
                    csr.screenClass = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block4;
                }
                HashMap<String, ConfigurationScreenRecord> byInteraction = (HashMap<String, ConfigurationScreenRecord>)this.configurationScreens.get(csr.primitiveTypeId);
                if (byInteraction == null) {
                    byInteraction = new HashMap<String, ConfigurationScreenRecord>();
                    this.configurationScreens.put(csr.primitiveTypeId, byInteraction);
                }
                ConfigurationScreenRecord obj = byInteraction.put(csr.interactionType, csr);
                System.out.println("Duplicate media screen registration: Old=" + obj + " New=" + csr);
            }
            ++i;
        }
    }

    public MediaConfigurationScreen getMediaConfigurationScreen(String primitiveTypeId, String interactionType) {
        ConfigurationScreenRecord csr;
        MediaConfigurationScreen ret = null;
        Map byInteraction = (Map)this.configurationScreens.get(primitiveTypeId);
        if (byInteraction != null && (csr = (ConfigurationScreenRecord)byInteraction.get(interactionType)) != null) {
            try {
                ret = (MediaConfigurationScreen)csr.screenClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public Map getIndexedMediaConfigurationScreens(String primitiveTypeId, Element element) {
        HashMap ret = new HashMap();
        Map byInteraction = (Map)this.configurationScreens.get(primitiveTypeId);
        if (byInteraction != null) {
            Set s = byInteraction.entrySet();
            for (Map.Entry entry : s) {
                ConfigurationScreenRecord csr = (ConfigurationScreenRecord)entry.getValue();
                if (csr == null) continue;
                try {
                    Constructor con = csr.screenClass.getConstructor(Element.class);
                    ret.put(entry.getKey(), con.newInstance(element));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private class ConfigurationScreenRecord {
        String primitiveTypeId;
        String interactionType;
        Class screenClass;

        private ConfigurationScreenRecord() {
        }
    }
}

