/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.media.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.media.PromptBindingItem;
import org.eclipse.vtp.desktop.core.configuration.media.PromptBindingItemEntry;
import org.eclipse.vtp.desktop.core.configuration.media.PromptMediaBinding;
import org.eclipse.vtp.desktop.media.core.PromptBindingDialog;
import org.eclipse.vtp.desktop.media.core.PromptBindingViewerListener;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FileContent;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.ReferencedContent;
import org.eclipse.vtp.framework.interactions.core.media.TextContent;

public class PromptBindingViewer
implements MouseListener {
    PromptMediaBinding promptBinding;
    Brand currentBrand;
    String currentLanguage;
    Label contents;
    String interactionType;
    List variables;
    List listeners = new ArrayList();

    public PromptBindingViewer(PromptMediaBinding promptBinding, String interactionType, List variables) {
        this.promptBinding = promptBinding;
        this.interactionType = interactionType;
        this.variables = variables;
    }

    public void createControls(Composite parent) {
        this.contents = new Label(parent, 64);
        this.contents.setBackground(parent.getBackground());
        this.contents.setText("Not Configured");
        this.contents.addMouseListener((MouseListener)this);
    }

    public Control getControl() {
        return this.contents;
    }

    public void setCurrentBrand(Brand brand) {
        System.out.println("new brand: " + brand.getName());
        this.currentBrand = brand;
        if (this.currentLanguage != null) {
            this.setContents();
        }
    }

    private void setContents() {
        StringBuffer buf = new StringBuffer();
        PromptBindingItem pbi = this.promptBinding.getPromptItem(this.currentBrand.getName(), this.interactionType, this.currentLanguage);
        List entries = pbi.getEntries();
        for (PromptBindingItemEntry pbie : entries) {
            FormattableContent fc;
            Content content = pbie.getContent();
            if (content instanceof FormattableContent) {
                fc = (FormattableContent)content;
                buf.append(String.valueOf(fc.getContentTypeName()) + "(" + fc.getFormatName() + ", " + fc.getValue() + ")");
            } else if (content instanceof TextContent) {
                String tc = ((TextContent)content).getText();
                boolean allWhite = true;
                char[] chars = tc.toCharArray();
                int ic = 0;
                while (ic < chars.length) {
                    if (!Character.isWhitespace(chars[ic])) {
                        allWhite = false;
                    }
                    ++ic;
                }
                buf.append(allWhite ? "TEXT(" + tc + ")" : tc);
            } else if (content instanceof ReferencedContent) {
                buf.append("REFERENCE(" + ((ReferencedContent)content).getReferencedName() + ")");
            } else if (content instanceof FileContent) {
                fc = (FileContent)content;
                buf.append(String.valueOf(fc.getFileTypeName()) + "(" + fc.getPath() + ")");
            }
            buf.append(' ');
        }
        System.out.println("New Prompt Contents: " + buf.toString());
        this.contents.setText(buf.length() < 1 ? "Not Configured" : buf.toString());
    }

    public void setCurrentLanguage(String language) {
        this.currentLanguage = language;
        System.out.println("new language: " + language);
        if (this.currentBrand != null) {
            this.setContents();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        try {
            System.out.println("mouse double click");
            System.out.println("MediaProvider: " + this.currentBrand.getMediaProvider(this.interactionType, this.currentLanguage));
            Shell workbenchShell = Display.getCurrent().getActiveShell();
            PromptBindingDialog pbd = new PromptBindingDialog(workbenchShell);
            PromptBindingItem pbi = this.promptBinding.getPromptItem(this.currentBrand.getName(), this.interactionType, this.currentLanguage);
            pbd.setPromptBinding((PromptBindingItem)pbi.clone(), this.currentBrand.getMediaProvider(this.interactionType, this.currentLanguage));
            pbd.setMediaProvider(this.currentBrand.getMediaProvider(this.interactionType, this.currentLanguage));
            pbd.setVariables(this.variables);
            int result = pbd.open();
            if (result == 0) {
                pbi = pbd.getPromptBindingItem();
                this.promptBinding.putPromptItem(this.currentBrand.getName(), this.interactionType, this.currentLanguage, pbi.getEntries().size() < 1 ? null : pbi);
                this.setContents();
                this.fireChange();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void addListener(PromptBindingViewerListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(PromptBindingViewerListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChange() {
        for (PromptBindingViewerListener listener : this.listeners) {
            listener.valueChanged(this);
        }
    }
}

