/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.voice;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.vtp.desktop.projects.core.IMediaProject;
import org.eclipse.vtp.desktop.projects.voice.internals.VoiceProject;
import org.eclipse.vtp.framework.util.Guid;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static String configTemplate = "<voice id=\"[id]\" name=\"[name]\" domain=\"[domain]\" language=\"[language]\" language-pack=\"[language-pack-id]\"></voice>";
    public static String personaPromptsTemplate = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><voice:descriptor xmlns:voice=\"http://eclipse.org/vtp/xml/media/voice#1.0\"><voice:shared-content/></voice:descriptor>";
    public static final String PLUGIN_ID = "org.eclipse.vtp.desktop.projects.voice";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static boolean isPersonaProject(IProject project) {
        try {
            return project.getNature("org.eclipse.vtp.desktop.projects.voice.VoicePersonaNature") != null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static IMediaProject convertToPersona(IProject project) throws CoreException {
        if (project.getDescription().hasNature("org.eclipse.vtp.desktop.projects.voice.VoicePersonaNature")) {
            return new VoiceProject(project);
        }
        return null;
    }

    public static void initializeMediaStructure(IProject mediaRoot) throws CoreException {
        IFile prompts = mediaRoot.getFile("Voice.xml");
        prompts.create((InputStream)new ByteArrayInputStream(personaPromptsTemplate.getBytes()), true, null);
        IFolder filesFolder = mediaRoot.getFolder("Media Files");
        filesFolder.create(true, true, null);
    }

    public static void initializePersonaStructure(IProject newProject, String name, String domainId, String language, String languagePackId) throws CoreException {
        Activator.initializeMediaStructure(newProject);
        IFile config = newProject.getFile(".config");
        String buf = new String(configTemplate);
        buf = buf.replaceAll("\\[id\\]", Guid.createGUID());
        buf = buf.replaceAll("\\[name\\]", name);
        buf = buf.replaceAll("\\[domain\\]", domainId);
        buf = buf.replaceAll("\\[language\\]", language);
        buf = buf.replaceAll("\\[language-pack-id\\]", languagePackId);
        config.create((InputStream)new ByteArrayInputStream(buf.toString().getBytes()), true, null);
    }
}

