/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.voice.actions;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import org.eclipse.vtp.desktop.core.actions.util.IProvisioningModelAction;
import org.eclipse.vtp.desktop.core.actions.util.IProvisioningModelSelection;
import org.eclipse.vtp.desktop.projects.core.IMediaFile;

public class PlayFileAction
implements IProvisioningModelAction {
    public String getName() {
        return "PlayFileAction";
    }

    public String getToolTip() {
        return "Plays an audio file";
    }

    public void performAction(IProvisioningModelSelection selection) {
        if (selection.getSelectedObject() instanceof IMediaFile) {
            IMediaFile mediaFile = (IMediaFile)selection.getSelectedObject();
            AudioFormat uLawformat = new AudioFormat(AudioFormat.Encoding.ULAW, 8000.0f, 8, 1, 1, 8000.0f, true);
            try {
                AudioInputStream ais;
                AudioInputStream pcmais = null;
                if (mediaFile.getName().endsWith("vox")) {
                    ais = new AudioInputStream(mediaFile.open(), uLawformat, mediaFile.length());
                    pcmais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
                } else {
                    ais = AudioSystem.getAudioInputStream(mediaFile.open());
                    pcmais = AudioSystem.getAudioInputStream(AudioFormat.Encoding.PCM_SIGNED, ais);
                }
                DataLine.Info dinfo = new DataLine.Info(Clip.class, pcmais.getFormat());
                Clip currentClip = (Clip)AudioSystem.getLine(dinfo);
                currentClip.open(pcmais);
                currentClip.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

