/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.voice.internals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.IMediaContainer;
import org.eclipse.vtp.desktop.projects.core.IMediaFilesFolder;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.event.IRefreshListener;
import org.eclipse.vtp.desktop.projects.voice.internals.VoiceModel;
import org.eclipse.vtp.desktop.projects.voice.internals.VoiceProject;
import org.eclipse.vtp.framework.interactions.core.media.Content;
import org.eclipse.vtp.framework.interactions.core.media.FormattableContent;
import org.eclipse.vtp.framework.interactions.core.media.IFormatManager;
import org.eclipse.vtp.framework.interactions.core.media.IFormatter;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.IResourceManager;
import org.eclipse.vtp.framework.interactions.core.media.ISharedContentProvider;
import org.eclipse.vtp.framework.media.ContentType;
import org.eclipse.vtp.framework.media.FormatterRegistration;
import org.eclipse.vtp.framework.media.FormatterRegistrationManager;

public class VoiceMediaProvider
implements IMediaProvider,
IRefreshListener {
    IFormatManager formatManager = new VoiceFormatManager();
    IResourceManager resourceManager = new VoiceResourceManager();
    ISharedContentProvider sharedContentProvider = new VoiceSharedContentManager();
    VoiceProject project = null;
    VoiceModel model = null;
    IFormatter formatter = null;

    public VoiceMediaProvider(VoiceProject project) {
        this.project = project;
        this.model = new VoiceModel(project);
        try {
            this.model.load();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        project.getPromptSet().addRefreshListener((IRefreshListener)this);
        try {
            FormatterRegistration fr = FormatterRegistrationManager.getInstance().getFormatter(project.getLanguagePackId());
            this.formatter = fr.getFormatter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IFormatManager getFormatManager() {
        return this.formatManager;
    }

    public IFormatter getFormatter() {
        return this.formatter;
    }

    public IResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ISharedContentProvider getSharedContentProvider() {
        return this.sharedContentProvider;
    }

    public List getSupportedContentTypes() {
        ArrayList<ContentType> types = new ArrayList<ContentType>();
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.text", "Text"));
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.referenced", "Reference"));
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.number", "Number"));
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.digits", "Digits"));
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.ordinal", "Ordinal"));
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.date", "Date"));
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.money", "Money"));
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.core.media.content.letters", "Characters"));
        types.add(new ContentType("org.eclipse.vtp.framework.interactions.voice.media.content.audio", "Audio File"));
        return types;
    }

    public boolean hasSharedContent() {
        return true;
    }

    public void refreshResource(IVoiceToolsResource resource) {
        if (this.project.getPromptSet().equals(resource)) {
            try {
                this.model.load();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    private class VoiceFormatManager
    implements IFormatManager {
        private VoiceFormatManager() {
        }

        public String getFormat(FormattableContent content, String formatName) {
            if (formatName.equals("Default")) {
                return "Default";
            }
            return VoiceMediaProvider.this.formatter.getDefaultFormatDefintion(content, formatName);
        }

        public List getFormats(FormattableContent content) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("Default");
            ret.addAll(VoiceMediaProvider.this.formatter.getDefaultFormats(content));
            return ret;
        }
    }

    private class VoiceResourceManager
    implements IResourceManager {
        private VoiceResourceManager() {
        }

        public boolean isDirectoryResource(String path) {
            return path == null || path.endsWith("/") && this.find(path) != null;
        }

        public boolean isFileResource(String path) {
            return path != null && !path.endsWith("/") && this.find(path) != null;
        }

        public String[] listResources(String directoryPath) {
            IVoiceToolsResource resource = this.find(directoryPath);
            if (resource instanceof IMediaContainer) {
                List resources = null;
                try {
                    resources = ((IMediaContainer)resource).listMediaResources();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
                String[] results = new String[resources.size()];
                int i = 0;
                for (IVoiceToolsResource item : resources) {
                    results[i] = item.getName();
                    if (item instanceof IMediaContainer) {
                        int n = i;
                        results[n] = String.valueOf(results[n]) + "/";
                    }
                    ++i;
                }
                return results;
            }
            return null;
        }

        private IVoiceToolsResource find(String path) {
            IMediaFilesFolder folder;
            if (path == null || path.length() == 0) {
                path = "/";
            }
            IMediaFilesFolder result = folder = VoiceMediaProvider.this.project.getMediaFilesFolder();
            StringTokenizer st = new StringTokenizer(path, "/");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (st.hasMoreTokens()) {
                    if ((folder = folder.getMediaFolder(token)) != null) continue;
                    return null;
                }
                result = folder.getMediaFolder(token);
                if (result != null) continue;
                result = folder.getMediaFile(token);
            }
            return result;
        }
    }

    private class VoiceSharedContentManager
    implements ISharedContentProvider {
        private VoiceSharedContentManager() {
        }

        public Content getSharedContent(String contentName) {
            return VoiceMediaProvider.this.model.getSharedContent(contentName);
        }

        public List listSharedContent() {
            return Arrays.asList(VoiceMediaProvider.this.model.getSharedContentNames());
        }
    }
}

