/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.voice.internals;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.vtp.desktop.projects.core.IMediaFilesFolder;
import org.eclipse.vtp.desktop.projects.core.IPromptSet;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.internals.MediaFilesFolder;
import org.eclipse.vtp.desktop.projects.core.internals.MediaProject;
import org.eclipse.vtp.desktop.projects.core.internals.PromptSet;
import org.eclipse.vtp.desktop.projects.voice.IVoiceProject;
import org.eclipse.vtp.desktop.projects.voice.internals.VoiceMediaProvider;
import org.eclipse.vtp.framework.interactions.core.media.IMediaProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class VoiceProject
extends MediaProject
implements IVoiceProject {
    private VoiceMediaProvider mediaProvider;
    private PromptSet promptSet;

    public VoiceProject(IProject project) {
        super(project);
        this.promptSet = new PromptSet(project.getFile("Voice.xml"), (IVoiceToolsResource)this);
        this.mediaProvider = new VoiceMediaProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMediaProjectId() throws CoreException {
        String ret = null;
        VoiceProject voiceProject = this;
        synchronized (voiceProject) {
            try {
                IFile buildPath = this.project.getFile(".config");
                DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = buildFactory.newDocumentBuilder();
                if (!buildPath.isSynchronized(2)) {
                    buildPath.refreshLocal(2, null);
                }
                Document doc = builder.parse(buildPath.getContents());
                Element root = doc.getDocumentElement();
                ret = root.getAttribute("id");
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLanguagePackId() throws CoreException {
        String ret = null;
        VoiceProject voiceProject = this;
        synchronized (voiceProject) {
            try {
                IFile buildPath = this.project.getFile(".config");
                DocumentBuilderFactory buildFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = buildFactory.newDocumentBuilder();
                Document doc = builder.parse(buildPath.getContents());
                Element root = doc.getDocumentElement();
                ret = root.getAttribute("language-pack");
            }
            catch (FactoryConfigurationError e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public IPromptSet getPromptSet() {
        return this.promptSet;
    }

    public IMediaFilesFolder getMediaFilesFolder() {
        IFolder f = this.project.getFolder("Media Files");
        if (!f.exists()) {
            throw new RuntimeException("Media Files is missing");
        }
        return new MediaFilesFolder((IVoiceToolsResource)this, f);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IVoiceProject) {
            IVoiceProject pp = (IVoiceProject)obj;
            try {
                if (pp.getMediaProjectId().equals(this.getMediaProjectId())) {
                    return true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return super.equals(obj);
    }

    public IMediaProvider getMediaProvider() {
        return this.mediaProvider;
    }
}

