/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.projects.voice.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.vtp.desktop.projects.voice.Activator;
import org.eclipse.vtp.framework.media.FormatterRegistration;
import org.eclipse.vtp.framework.media.FormatterRegistrationManager;

public class CreateVoiceWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private PersonaInformationPage personaInformationPage = null;
    private IConfigurationElement configElement = null;
    private List formatters = null;

    public CreateVoiceWizard() {
        this.setWindowTitle("New Voice Wizard");
        this.formatters = FormatterRegistrationManager.getInstance().getFormattersForInteractionType("org.eclipse.vtp.framework.interactions.voice.interaction");
        this.personaInformationPage = new PersonaInformationPage();
        this.addPage((IWizardPage)this.personaInformationPage);
    }

    public boolean performFinish() {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.personaInformationPage.personaName.getText());
        try {
            newProject.create(null);
            newProject.open(null);
            IProjectDescription desc = newProject.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.vtp.desktop.projects.voice.VoicePersonaNature"});
            newProject.setDescription(desc, null);
            FormatterRegistration fr = (FormatterRegistration)this.formatters.get(this.personaInformationPage.languagePackSelector.getSelectionIndex());
            Activator.initializePersonaStructure(newProject, newProject.getName(), "", "", fr.getId());
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
    }

    private class PersonaInformationPage
    extends WizardPage {
        Text personaName;
        Combo languagePackSelector;
        List languagePacks;

        public PersonaInformationPage() {
            super("VoiceInformationPage", "Voice Information", null);
            this.languagePacks = new ArrayList();
        }

        public void createControl(Composite parent) {
            this.setPageComplete(false);
            Composite comp = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.makeColumnsEqualWidth = false;
            comp.setLayout((Layout)gl);
            Label nameLabel = new Label(comp, 0);
            nameLabel.setText("Name:");
            this.personaName = new Text(comp, 2052);
            this.personaName.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    boolean ok = true;
                    IProject[] projs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int i = 0;
                    while (i < projs.length) {
                        if (projs[i].getName().equalsIgnoreCase(PersonaInformationPage.this.personaName.getText())) {
                            PersonaInformationPage.this.setPageComplete(false);
                            PersonaInformationPage.this.setErrorMessage("There is already a project with that name.");
                            ok = false;
                        }
                        ++i;
                    }
                    if (ok) {
                        PersonaInformationPage.this.setPageComplete(true);
                        PersonaInformationPage.this.setErrorMessage(null);
                    }
                }
            });
            Label languageLabel = new Label(comp, 0);
            languageLabel.setText("Formatter:");
            this.languagePackSelector = new Combo(comp, 2060);
            nameLabel.setLayoutData((Object)new GridData());
            this.personaName.setLayoutData((Object)new GridData(768));
            languageLabel.setLayoutData((Object)new GridData());
            this.languagePackSelector.setLayoutData((Object)new GridData(768));
            this.setControl((Control)comp);
            for (FormatterRegistration fr : CreateVoiceWizard.this.formatters) {
                this.languagePackSelector.add(String.valueOf(fr.getName()) + "(" + fr.getVendor() + ")");
            }
            this.languagePackSelector.select(0);
        }
    }
}

