/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.vtp.desktop.core.actions.ProvisioningModelSelection;
import org.eclipse.vtp.desktop.core.actions.util.IProvisioningModelSelection;
import org.eclipse.vtp.desktop.core.actions.util.ProvisioningModelActionManager;
import org.eclipse.vtp.desktop.projects.core.DesktopCorePlugin;
import org.eclipse.vtp.desktop.projects.core.IApplicationDesign;
import org.eclipse.vtp.desktop.projects.core.IApplicationFragment;
import org.eclipse.vtp.desktop.projects.core.IApplicationFragmentProject;
import org.eclipse.vtp.desktop.projects.core.IApplicationProject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObject;
import org.eclipse.vtp.desktop.projects.core.IBusinessObjectSet;
import org.eclipse.vtp.desktop.projects.core.IDatabase;
import org.eclipse.vtp.desktop.projects.core.IDatabaseSet;
import org.eclipse.vtp.desktop.projects.core.IDatabaseTable;
import org.eclipse.vtp.desktop.projects.core.IDependencySet;
import org.eclipse.vtp.desktop.projects.core.IMediaContainer;
import org.eclipse.vtp.desktop.projects.core.IMediaFile;
import org.eclipse.vtp.desktop.projects.core.IMediaFilesFolder;
import org.eclipse.vtp.desktop.projects.core.IMediaFolder;
import org.eclipse.vtp.desktop.projects.core.IMediaProject;
import org.eclipse.vtp.desktop.projects.core.IPromptSet;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsDesignProject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsProject;
import org.eclipse.vtp.desktop.projects.core.IVoiceToolsResource;
import org.eclipse.vtp.desktop.projects.core.IWebService;
import org.eclipse.vtp.desktop.projects.core.IWebServicePort;
import org.eclipse.vtp.desktop.projects.core.IWebServiceSet;
import org.eclipse.vtp.desktop.projects.core.MediaProjectManager;
import org.eclipse.vtp.desktop.projects.core.event.IRefreshListener;
import org.eclipse.vtp.desktop.projects.core.internals.ApplicationDesign;
import org.eclipse.vtp.desktop.projects.core.internals.ApplicationFragment;

public class ProjectsView
extends ViewPart {
    private TreeViewer viewer = null;
    ProvisioningModelActionManager pmam = new ProvisioningModelActionManager();
    private DropTarget dropTarget = null;
    private DeleteResourceAction deleteProjectsAction;

    public ProjectsView() {
        this.pmam.loadExtensionPoint("org.eclipse.vtp.desktop.projects.core.applicationModelViewActionSets");
        this.pmam.loadExtensionPoint("org.eclipse.vtp.desktop.ui.app.projectViewActionSets");
    }

    public void createPartControl(Composite parent) {
        this.deleteProjectsAction = new DeleteResourceAction(parent.getShell());
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ProjectsContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setSorter((ViewerSorter)new ProjectsSorter());
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(final TreeExpansionEvent event) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        ProjectsView.this.viewer.update(event.getElement(), new String[]{"label"});
                    }
                });
            }

            public void treeExpanded(final TreeExpansionEvent event) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        ProjectsView.this.viewer.update(event.getElement(), new String[]{"label"});
                    }
                });
            }
        });
        this.dropTarget = new DropTarget(this.viewer.getControl(), 19);
        this.dropTarget.addDropListener(new DropTargetListener(){
            int initialOperation;

            public void dragEnter(DropTargetEvent event) {
                this.initialOperation = event.detail;
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.initialOperation = event.detail;
            }

            public void dragOver(DropTargetEvent event) {
                Object obj;
                System.out.println("dnd type: " + event.detail);
                TreeItem ti = (TreeItem)event.item;
                event.detail = ti != null ? ((obj = ti.getData()) instanceof IMediaContainer || obj instanceof IWebServiceSet || obj instanceof IDependencySet ? 1 : 0) : 0;
            }

            public void drop(DropTargetEvent event) {
                TreeItem ti = (TreeItem)event.item;
                if (ti.getData() instanceof IMediaContainer) {
                    IMediaContainer container = (IMediaContainer)ti.getData();
                    Object obj = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                    if (obj != null) {
                        String[] fileNames = (String[])obj;
                        try {
                            int i = 0;
                            while (i < fileNames.length) {
                                File f = new File(fileNames[i]);
                                if (f.exists()) {
                                    if (f.isDirectory()) {
                                        ProjectsView.this.copyDirectory(f, container);
                                    } else {
                                        ProjectsView.this.copyFile(f, container);
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        ProjectsView.this.viewer.refresh((Object)container);
                    }
                } else if (ti.getData() instanceof IWebServiceSet) {
                    IWebServiceSet container = (IWebServiceSet)ti.getData();
                    Object obj = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                    if (obj != null) {
                        String[] fileNames = (String[])obj;
                        try {
                            int i = 0;
                            while (i < fileNames.length) {
                                File f = new File(fileNames[i]);
                                if (f.exists() && !f.isDirectory()) {
                                    try {
                                        String name = f.getName();
                                        int lastDot = name.lastIndexOf(46);
                                        if (lastDot > 0) {
                                            name = name.substring(0, lastDot);
                                        }
                                        container.createWebService(name, f.toURL());
                                    }
                                    catch (MalformedURLException e) {
                                        e.printStackTrace();
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        ProjectsView.this.viewer.refresh((Object)container);
                    }
                } else if (ti.getData() instanceof IDependencySet) {
                    IDependencySet container = (IDependencySet)ti.getData();
                    Object obj = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                    if (obj != null) {
                        String[] fileNames = (String[])obj;
                        int i = 0;
                        while (i < fileNames.length) {
                            File f = new File(fileNames[i]);
                            if (f.exists() && f.getName().endsWith(".jar")) {
                                try {
                                    container.createDependency(f.getName(), f.toURL());
                                }
                                catch (MalformedURLException e) {
                                    e.printStackTrace();
                                }
                            }
                            ++i;
                        }
                        ProjectsView.this.viewer.refresh((Object)container);
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
                TreeItem ti = (TreeItem)event.item;
                if (ti != null) {
                    Object obj = ti.getData();
                    if (obj instanceof IMediaContainer) {
                        event.detail = 1;
                    } else if (obj instanceof IWebServiceSet) {
                        System.out.println(event);
                        System.out.println(event.currentDataType);
                        System.out.println(FileTransfer.getInstance().isSupportedType(event.currentDataType));
                        int i = 0;
                        while (i < event.dataTypes.length) {
                            System.out.println(event.dataTypes[i]);
                            System.out.println(FileTransfer.getInstance().isSupportedType(event.dataTypes[i]));
                            System.out.println(FileTransfer.getInstance().nativeToJava(event.currentDataType));
                            ++i;
                        }
                        Object files = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                        System.out.println(files);
                        if (files instanceof String[]) {
                            boolean allWSDL = true;
                            String[] fileNames = (String[])files;
                            int i2 = 0;
                            while (i2 < fileNames.length) {
                                if (!fileNames[i2].endsWith(".wsdl")) {
                                    allWSDL = false;
                                    break;
                                }
                                ++i2;
                            }
                            event.detail = allWSDL ? 1 : 0;
                        } else {
                            event.detail = 1;
                        }
                    } else if (obj instanceof IDependencySet) {
                        Object files = FileTransfer.getInstance().nativeToJava(event.currentDataType);
                        if (files instanceof String[]) {
                            boolean allJARs = true;
                            String[] fileNames = (String[])files;
                            int i = 0;
                            while (i < fileNames.length) {
                                if (!fileNames[i].endsWith(".jar")) {
                                    allJARs = false;
                                    break;
                                }
                                ++i;
                            }
                            event.detail = allJARs ? 1 : 0;
                        } else {
                            event.detail = 1;
                        }
                    } else {
                        event.detail = 0;
                    }
                } else {
                    event.detail = 0;
                }
            }
        });
        this.dropTarget.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProjectsView.this.dropTarget.dispose();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.hookSelectionListener();
        this.contributeToActionBars();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void makeActions() {
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProjectsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IVoiceToolsResource selection = (IVoiceToolsResource)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selection instanceof IVoiceToolsProject || selection instanceof IMediaContainer || selection instanceof IBusinessObjectSet || selection instanceof IDatabaseSet || selection instanceof IDatabase) {
                    if (ProjectsView.this.viewer.getExpandedState((Object)selection)) {
                        ProjectsView.this.viewer.collapseToLevel((Object)selection, -1);
                    } else {
                        ProjectsView.this.viewer.expandToLevel((Object)selection, 1);
                    }
                } else if (selection instanceof IApplicationDesign) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((ApplicationDesign)selection).getUnderlyingFile());
                    }
                    catch (PartInitException e1) {
                        e1.printStackTrace();
                    }
                } else if (selection instanceof IApplicationFragment) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((ApplicationFragment)selection).getUnderlyingFile());
                    }
                    catch (PartInitException e1) {
                        e1.printStackTrace();
                    }
                } else if (selection instanceof IPromptSet) {
                    IPromptSet promptSet = (IPromptSet)selection;
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)promptSet.getUnderlyingFile());
                    }
                    catch (PartInitException e) {
                        ProjectsView.this.showMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (selection instanceof IBusinessObject) {
                    IBusinessObject businessObject = (IBusinessObject)selection;
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)businessObject.getUnderlyingFile());
                    }
                    catch (PartInitException e) {
                        ProjectsView.this.showMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (selection instanceof IDatabaseTable) {
                    IDatabaseTable databaseTable = (IDatabaseTable)selection;
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)databaseTable.getUnderlyingFile());
                    }
                    catch (PartInitException e) {
                        ProjectsView.this.showMessage(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (selection instanceof IMediaFile) {
                    IMediaFile file = (IMediaFile)selection;
                    IVoiceToolsResource parent = file.getParent();
                    while (!(parent instanceof IMediaFilesFolder)) {
                        parent = parent.getParent();
                    }
                    LinkedList<IVoiceToolsResource> parents = new LinkedList<IVoiceToolsResource>();
                    while (!(parent instanceof IVoiceToolsProject)) {
                        parents.addFirst(parent);
                        parent = parent.getParent();
                    }
                    StringBuffer buf = new StringBuffer();
                    Iterator i = parents.iterator();
                    while (i.hasNext()) {
                        buf.append(((IVoiceToolsResource)i.next()).getName()).append('/');
                    }
                    buf.setLength(buf.length() - 1);
                    buf.append(file.getMediaPath());
                    final IFile ifile = selection.getProject().getUnderlyingProject().getFile(buf.toString());
                    ProjectsView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            try {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)ifile, (boolean)true);
                            }
                            catch (PartInitException partInitException) {}
                        }
                    });
                }
            }
        });
    }

    private void hookSelectionListener() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    Object obj = selection.getFirstElement();
                    ProjectsView.this.pmam.selectionChanged((IProvisioningModelSelection)new ProvisioningModelSelection(obj));
                } else {
                    ProjectsView.this.pmam.selectionChanged((IProvisioningModelSelection)new ProvisioningModelSelection(null));
                }
            }
        });
        this.pmam.selectionChanged((IProvisioningModelSelection)new ProvisioningModelSelection(null));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        this.pmam.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator("additions"));
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        boolean allProjects = true;
        for (Object obj : selection) {
            System.out.println("Selection is: " + obj);
            if (obj instanceof IProject || obj instanceof IAdaptable && ((IAdaptable)obj).getAdapter(IProject.class) != null) continue;
            allProjects = false;
        }
        if (allProjects) {
            this.deleteProjectsAction.selectionChanged(selection);
            manager.add((IAction)this.deleteProjectsAction);
        }
        manager.add((IAction)ActionFactory.EXPORT.create(this.getSite().getWorkbenchWindow()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new PropertyDialogAction((IShellProvider)new SameShellProvider(this.viewer.getControl()), (ISelectionProvider)this.viewer));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Projects", (String)message);
    }

    private boolean isApplicationProject(IProject project) {
        try {
            return project.getNature("org.eclipse.vtp.desktop.projects.core.VoiceApplicationNature") != null;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isPersonaProject(IProject project) {
        return MediaProjectManager.getInstance().isMediaProject(project);
    }

    public TreeItem findItem(Tree tree, int index) {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem[] tis = tree.getItems();
        int i = 0;
        while (i < tis.length) {
            items.add(tis[i]);
            if (tis[i].getExpanded()) {
                this.loadItems(items, tis[i]);
            }
            ++i;
        }
        if (index < items.size()) {
            return (TreeItem)items.get(index);
        }
        return null;
    }

    public void loadItems(List list, TreeItem parent) {
        TreeItem[] tis = parent.getItems();
        int i = 0;
        while (i < tis.length) {
            list.add(tis[i]);
            if (tis[i].getExpanded()) {
                this.loadItems(list, tis[i]);
            }
            ++i;
        }
    }

    public void copyDirectory(File f, IMediaContainer container) throws CoreException {
        IMediaFolder folder = container.makeDirectory(f.getName());
        File[] fs = f.listFiles();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].isDirectory()) {
                this.copyDirectory(fs[i], (IMediaContainer)folder);
            } else {
                this.copyFile(fs[i], (IMediaContainer)folder);
            }
            ++i;
        }
    }

    public void copyFile(File f, IMediaContainer container) throws CoreException {
        try {
            FileInputStream fis = new FileInputStream(f);
            container.create(f.getName(), (InputStream)fis, null);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new WorkbenchException("Problems coping file" + e);
        }
    }

    private class ProjectsContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider,
    IResourceChangeListener {
        private ProjectsContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            if (oldInput instanceof IWorkspace) {
                ((IWorkspace)oldInput).removeResourceChangeListener((IResourceChangeListener)this);
            }
            if (newInput instanceof IWorkspace) {
                ((IWorkspace)newInput).addResourceChangeListener((IResourceChangeListener)this, 1);
            }
        }

        public Object[] getElements(Object parent) {
            if (!((IWorkspace)parent).getRoot().isSynchronized(1)) {
                try {
                    ((IWorkspace)parent).getRoot().refreshLocal(1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            IProject[] projects = ((IWorkspace)parent).getRoot().getProjects();
            ArrayList<Object> results = new ArrayList<Object>(projects.length);
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen()) {
                    if (!projects[i].isSynchronized(2)) {
                        try {
                            projects[i].refreshLocal(2, null);
                            projects[i].open(null);
                        }
                        catch (CoreException e1) {
                            e1.printStackTrace();
                        }
                    }
                    if (ProjectsView.this.isApplicationProject(projects[i])) {
                        try {
                            results.add(DesktopCorePlugin.convertToApplication((IProject)projects[i]));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    } else if (DesktopCorePlugin.isApplicationFragmentProject((IProject)projects[i])) {
                        try {
                            results.add(DesktopCorePlugin.convertToApplicationFragment((IProject)projects[i]));
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    } else if (ProjectsView.this.isPersonaProject(projects[i])) {
                        results.add(MediaProjectManager.getInstance().convertToMediaProject(projects[i]));
                    }
                }
                ++i;
            }
            return results.toArray();
        }

        public Object getParent(Object child) {
            return child instanceof IVoiceToolsResource ? ((IVoiceToolsResource)child).getParent() : null;
        }

        public Object[] getChildren(Object parent) {
            try {
                if (parent instanceof IVoiceToolsDesignProject) {
                    Object[] ret = new Object[5];
                    if (parent instanceof IApplicationProject) {
                        ret[0] = ((IApplicationProject)parent).getApplicationDesign();
                    } else if (parent instanceof IApplicationFragmentProject) {
                        ret[0] = ((IApplicationFragmentProject)parent).getApplicationFragment();
                    }
                    ret[1] = ((IVoiceToolsDesignProject)parent).getBusinessObjectSet();
                    ret[2] = ((IVoiceToolsDesignProject)parent).getDatabaseSet();
                    ret[3] = ((IVoiceToolsDesignProject)parent).getWebServiceSet();
                    ret[4] = ((IVoiceToolsDesignProject)parent).getDependencySet();
                    return ret;
                }
                if (parent instanceof IMediaProject) {
                    IMediaProject personaProject = (IMediaProject)parent;
                    return new Object[]{personaProject.getPromptSet(), personaProject.getMediaFilesFolder()};
                }
                if (parent instanceof IBusinessObjectSet) {
                    final IBusinessObjectSet businessObjectSet = (IBusinessObjectSet)parent;
                    businessObjectSet.addRefreshListener(new IRefreshListener(){

                        public void refreshResource(IVoiceToolsResource resource) {
                            ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectsView.this.viewer.refresh((Object)businessObjectSet);
                                    ProjectsView.this.viewer.expandToLevel((Object)businessObjectSet, 1);
                                }
                            });
                        }
                    });
                    return businessObjectSet.getBusinessObjects().toArray();
                }
                if (parent instanceof IDatabaseSet) {
                    final IDatabaseSet databaseSet = (IDatabaseSet)parent;
                    databaseSet.addRefreshListener(new IRefreshListener(){

                        public void refreshResource(IVoiceToolsResource resource) {
                            ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectsView.this.viewer.refresh((Object)databaseSet);
                                    ProjectsView.this.viewer.expandToLevel((Object)databaseSet, 1);
                                }
                            });
                        }
                    });
                    return databaseSet.getDatabases().toArray();
                }
                if (parent instanceof IDatabase) {
                    final IDatabase database = (IDatabase)parent;
                    database.addRefreshListener(new IRefreshListener(){

                        public void refreshResource(IVoiceToolsResource resource) {
                            ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectsView.this.viewer.refresh((Object)database);
                                }
                            });
                        }
                    });
                    return database.getTables().toArray();
                }
                if (parent instanceof IWebServiceSet) {
                    final IWebServiceSet webServiceSet = (IWebServiceSet)parent;
                    webServiceSet.addRefreshListener(new IRefreshListener(){

                        public void refreshResource(IVoiceToolsResource resource) {
                            ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectsView.this.viewer.refresh((Object)webServiceSet);
                                    ProjectsView.this.viewer.expandToLevel((Object)webServiceSet, 1);
                                }
                            });
                        }
                    });
                    return webServiceSet.getWebServices().toArray();
                }
                if (parent instanceof IWebService) {
                    final IWebService webService = (IWebService)parent;
                    webService.addRefreshListener(new IRefreshListener(){

                        public void refreshResource(IVoiceToolsResource resource) {
                            ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectsView.this.viewer.refresh((Object)webService);
                                    ProjectsView.this.viewer.expandToLevel((Object)webService, 1);
                                }
                            });
                        }
                    });
                    return webService.getWebServicePorts().toArray();
                }
                if (parent instanceof IWebServicePort) {
                    final IWebServicePort webServicePort = (IWebServicePort)parent;
                    webServicePort.addRefreshListener(new IRefreshListener(){

                        public void refreshResource(IVoiceToolsResource resource) {
                            ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectsView.this.viewer.refresh((Object)webServicePort);
                                    ProjectsView.this.viewer.expandToLevel((Object)webServicePort, 1);
                                }
                            });
                        }
                    });
                    return webServicePort.getWebServiceOperations().toArray();
                }
                if (parent instanceof IMediaContainer) {
                    final IMediaContainer container = (IMediaContainer)parent;
                    container.addRefreshListener(new IRefreshListener(){

                        public void refreshResource(IVoiceToolsResource resource) {
                            ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectsView.this.viewer.refresh((Object)container);
                                }
                            });
                        }
                    });
                    return container.listMediaResources().toArray();
                }
                if (parent instanceof IDependencySet) {
                    System.out.println("######################################################displaying dependency set contents");
                    final IDependencySet dependencies = (IDependencySet)parent;
                    dependencies.addRefreshListener(new IRefreshListener(){

                        public void refreshResource(IVoiceToolsResource resource) {
                            ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    ProjectsView.this.viewer.refresh((Object)dependencies);
                                }
                            });
                        }
                    });
                    return dependencies.getDependencies().toArray();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof IVoiceToolsDesignProject || parent instanceof IMediaProject || parent instanceof IMediaContainer || parent instanceof IBusinessObjectSet || parent instanceof IDatabaseSet || parent instanceof IDatabase || parent instanceof IWebServiceSet || parent instanceof IWebService || parent instanceof IDependencySet || parent instanceof IWebServicePort;
        }

        public void dispose() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            final boolean[] bs = new boolean[1];
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getKind() == 1 && (delta.getResource().getName().equals(".buildPath") || delta.getResource().getName().equals(".config"))) {
                            bs[0] = true;
                        } else if (delta.getKind() == 2) {
                            bs[0] = true;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (bs[0]) {
                ProjectsView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ProjectsView.this.viewer.refresh();
                    }
                });
            }
        }
    }

    private final class ProjectsSorter
    extends ViewerSorter {
        private ProjectsSorter() {
        }

        public int category(Object element) {
            if (element instanceof IApplicationDesign || element instanceof IPromptSet) {
                return 1;
            }
            if (element instanceof IApplicationFragment) {
                return 2;
            }
            if (element instanceof IMediaContainer) {
                return 3;
            }
            return 4;
        }
    }
}

