/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views.canvas;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vtp.desktop.core.wizards.AddDesignCanvasWizard;
import org.eclipse.vtp.desktop.views.canvas.CanvasBrowserContentProvider;
import org.eclipse.vtp.desktop.views.canvas.CanvasBrowserContentProviderListener;
import org.eclipse.vtp.desktop.views.canvas.IconicCanvas;
import org.eclipse.vtp.desktop.views.canvas.IconicCanvasListener;
import org.eclipse.vtp.desktop.views.pallet.PalletItemTransfer;

public class CanvasBrowser
implements CanvasBrowserContentProviderListener {
    private static final int SELECTED_BORDER_WIDTH = 2;
    private Composite comp;
    private CanvasBrowserContentProvider provider;
    List widgets = new ArrayList();
    ScrolledComposite sc = null;

    public void setContentProvider(CanvasBrowserContentProvider provider) {
        this.provider = provider;
        provider.addListener(this);
        List iconicCanvases = provider.listCanvases();
        for (IconicCanvas canvas : iconicCanvases) {
            this.widgets.add(new CanvasWidget(canvas));
        }
    }

    public void createControls(Composite parent) {
        this.sc = new ScrolledComposite(parent, 768);
        this.sc.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                System.out.println("in SC dispose listener");
                CanvasBrowser.this.provider.removeListener(CanvasBrowser.this);
            }
        });
        this.sc.setAlwaysShowScrollBars(false);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.comp = new Composite((Composite)this.sc, 0);
        this.comp.setBackground(parent.getDisplay().getSystemColor(1));
        this.comp.setLayout((Layout)new GridLayout(1, false));
        this.addWidgets(this.comp);
        this.sc.setContent((Control)this.comp);
        this.sc.setMinSize(this.comp.computeSize(-1, -1));
        this.hookContextMenu();
    }

    private void updateScroll() {
        this.sc.setMinSize(this.comp.computeSize(-1, -1));
    }

    private void addWidgets(Composite parent) {
        for (CanvasWidget widget : this.widgets) {
            widget.createControls(parent);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CanvasBrowser.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.comp);
        this.comp.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.provider.supportsMultipleCanvases()) {
            manager.add((IAction)new Action("Add Canvas"){

                public void run() {
                    String[] names = new String[CanvasBrowser.this.widgets.size()];
                    int i = 0;
                    while (i < names.length) {
                        names[i] = ((CanvasWidget)CanvasBrowser.this.widgets.get((int)i)).nameLabel.getText();
                        ++i;
                    }
                    AddDesignCanvasWizard adcw = new AddDesignCanvasWizard(names);
                    WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)adcw);
                    int result = wd.open();
                    if (result == 0) {
                        String canvasName = adcw.getCanvasName();
                        IconicCanvas ic = CanvasBrowser.this.provider.addCanvas(canvasName);
                        CanvasWidget cw = new CanvasWidget(ic);
                        CanvasBrowser.this.widgets.add(cw);
                        cw.createControls(CanvasBrowser.this.comp);
                        CanvasBrowser.this.comp.layout();
                        CanvasBrowser.this.updateScroll();
                        CanvasBrowser.this.provider.selectCanvas(ic);
                    }
                }
            });
        }
    }

    public Control getControl() {
        return this.comp;
    }

    private class CanvasWidget
    implements PaintListener,
    IconicCanvasListener,
    MouseListener {
        IconicCanvas icon;
        Canvas canvas;
        StackLayout nameStackLayout = null;
        Composite nameStack = null;
        Label nameLabel = null;
        Text nameText = null;
        Composite canvasComp = null;
        Font f = null;
        DropTarget dropTarget = null;

        public CanvasWidget(IconicCanvas icon) {
            this.icon = icon;
            icon.addListener(this);
        }

        public void createControls(Composite parent) {
            this.f = new Font((Device)parent.getDisplay(), "Arial", 12, 1);
            this.canvasComp = new Composite(parent, 0);
            this.canvasComp.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    System.out.println("removing listener");
                    CanvasWidget.this.icon.removeListener(CanvasWidget.this);
                    if (CanvasWidget.this.canvasComp.isDisposed()) {
                        return;
                    }
                    if (CanvasWidget.this.dropTarget != null) {
                        CanvasWidget.this.dropTarget.dispose();
                    }
                }
            });
            this.canvasComp.setBackground(parent.getBackground());
            GridData gd = new GridData(768);
            gd.horizontalAlignment = 0x1000000;
            gd.verticalAlignment = 128;
            this.canvasComp.setLayoutData((Object)gd);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginHeight += 2;
            gridLayout.marginWidth += 2;
            this.canvasComp.setLayout((Layout)gridLayout);
            this.canvas = new Canvas(this.canvasComp, 0x20000800){

                public Point computeSize(int wHint, int hHint, boolean changed) {
                    return new Point((int)((float)CanvasWidget.this.icon.getCanvasWidth() * 0.15f) + this.getBorderWidth(), (int)((float)CanvasWidget.this.icon.getCanvasHeight() * 0.15f) + this.getBorderWidth());
                }

                public void dispose() {
                    CanvasWidget.this.f.dispose();
                    super.dispose();
                }
            };
            this.canvas.setBackground(parent.getDisplay().getSystemColor(1));
            this.canvas.addPaintListener((PaintListener)this);
            this.canvas.addMouseListener((MouseListener)this);
            gd = new GridData();
            gd.horizontalAlignment = 0x1000000;
            gd.verticalAlignment = 128;
            this.canvas.setLayoutData((Object)gd);
            this.nameStackLayout = new StackLayout();
            this.nameStack = new Composite(this.canvasComp, 0);
            this.nameStack.setBackground(this.canvasComp.getBackground());
            this.nameStack.setLayout((Layout)this.nameStackLayout);
            this.nameStack.setLayoutData((Object)new GridData(1808));
            this.nameLabel = new Label(this.nameStack, 0);
            this.nameLabel.setBackground(this.nameStack.getBackground());
            this.nameLabel.setAlignment(0x1000000);
            this.nameLabel.setText(this.icon.getCanvasName());
            this.nameLabel.setFont(this.f);
            this.nameLabel.addMouseListener((MouseListener)this);
            this.nameText = new Text(this.nameStack, 2048);
            final SelectionListener nameTextListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    CanvasWidget.this.nameStackLayout.topControl = CanvasWidget.this.nameLabel;
                    String newName = CanvasWidget.this.nameText.getText();
                    if (newName != null && newName.length() > 0 && !newName.equals(CanvasWidget.this.icon.getCanvasName())) {
                        CanvasWidget.this.icon.setCanvasName(newName);
                        CanvasWidget.this.nameLabel.setText(newName);
                        CanvasBrowser.this.comp.layout(true);
                    }
                    CanvasWidget.this.nameStack.layout(true);
                }
            };
            this.nameText.addSelectionListener(nameTextListener);
            this.nameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    nameTextListener.widgetDefaultSelected(null);
                }
            });
            this.nameStackLayout.topControl = this.nameLabel;
            this.nameStack.layout(true);
            this.hookContextMenu();
            this.dropTarget = new DropTarget((Control)this.canvasComp, 19);
            this.dropTarget.addDropListener(new DropTargetListener(){

                public void dragEnter(DropTargetEvent event) {
                }

                public void dragOver(DropTargetEvent event) {
                    if (!CanvasWidget.this.icon.isSelectedCanvas()) {
                        CanvasBrowser.this.provider.selectCanvas(CanvasWidget.this.icon);
                    }
                }

                public void dragLeave(DropTargetEvent event) {
                }

                public void dragOperationChanged(DropTargetEvent event) {
                }

                public void dropAccept(DropTargetEvent event) {
                    event.detail = 0;
                }

                public void drop(DropTargetEvent event) {
                }
            });
            this.dropTarget.setTransfer(new Transfer[]{PalletItemTransfer.getInstance()});
            this.canvasComp.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (!CanvasWidget.this.icon.isSelectedCanvas()) {
                        return;
                    }
                    int x = 0;
                    int y = 0;
                    int w = e.width - 1;
                    int h = e.height - 1;
                    Color fg = e.gc.getForeground();
                    e.gc.setForeground(CanvasWidget.this.canvasComp.getDisplay().getSystemColor(26));
                    int i = 0;
                    while (i < 2) {
                        e.gc.drawRectangle(x, y, w, h);
                        ++x;
                        ++y;
                        w -= 2;
                        h -= 2;
                        ++i;
                    }
                    e.gc.setForeground(fg);
                }
            });
        }

        private void hookContextMenu() {
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    CanvasWidget.this.fillContextMenu(manager);
                }
            });
            Menu menu = menuMgr.createContextMenu((Control)this.canvas);
            this.canvas.setMenu(menu);
            MenuManager menuMgr2 = new MenuManager("#PopupMenu");
            menuMgr2.setRemoveAllWhenShown(true);
            menuMgr2.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    CanvasWidget.this.fillContextMenu(manager);
                }
            });
            Menu menu2 = menuMgr2.createContextMenu((Control)this.nameLabel);
            this.nameLabel.setMenu(menu2);
        }

        private void fillContextMenu(IMenuManager manager) {
            if (CanvasBrowser.this.provider.supportsMultipleCanvases()) {
                manager.add((IAction)new Action("Add Canvas"){

                    public void run() {
                        String[] names = new String[((CanvasWidget)CanvasWidget.this).CanvasBrowser.this.widgets.size()];
                        int i = 0;
                        while (i < names.length) {
                            names[i] = ((CanvasWidget)((CanvasWidget)CanvasWidget.this).CanvasBrowser.this.widgets.get((int)i)).nameLabel.getText();
                            ++i;
                        }
                        AddDesignCanvasWizard adcw = new AddDesignCanvasWizard(names);
                        WizardDialog wd = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)adcw);
                        int result = wd.open();
                        if (result == 0) {
                            String canvasName = adcw.getCanvasName();
                            IconicCanvas ic = CanvasBrowser.this.provider.addCanvas(canvasName);
                            CanvasWidget cw = new CanvasWidget(ic);
                            ((CanvasWidget)CanvasWidget.this).CanvasBrowser.this.widgets.add(cw);
                            cw.createControls(CanvasBrowser.this.comp);
                            CanvasBrowser.this.comp.layout();
                            CanvasBrowser.this.updateScroll();
                            CanvasBrowser.this.provider.selectCanvas(ic);
                        }
                    }
                });
            }
            if (!this.icon.isPrimaryCanvas()) {
                manager.add((IAction)new Action("Delete Canvas"){

                    public void run() {
                        MessageBox confirmationDialog = new MessageBox(Display.getCurrent().getActiveShell(), 200);
                        confirmationDialog.setMessage("Are you sure you want to delete this canvas and all the elements it contains?");
                        int result = confirmationDialog.open();
                        if (result == 64) {
                            CanvasBrowser.this.provider.deleteCanvas(CanvasWidget.this.icon);
                            ((CanvasWidget)CanvasWidget.this).CanvasBrowser.this.widgets.remove(CanvasWidget.this);
                            CanvasWidget.this.dispose();
                            CanvasBrowser.this.comp.layout();
                            CanvasBrowser.this.updateScroll();
                        }
                    }
                });
            }
        }

        public void dispose() {
            this.icon.removeListener(this);
            if (this.canvasComp != null && !this.canvasComp.isDisposed()) {
                this.canvasComp.dispose();
            }
        }

        public void paintControl(PaintEvent e) {
            float scale = 0.145f;
            Transform t = new Transform(e.gc.getDevice(), scale, 0.0f, 0.0f, scale, 0.0f, 0.0f);
            e.gc.setTransform(t);
            this.icon.render(e.gc, 15);
            t.dispose();
        }

        public void canvasUpdated(IconicCanvas canvas) {
            this.nameLabel.setText(canvas.getCanvasName());
            this.canvasComp.layout(true, true);
            CanvasBrowser.this.comp.layout(true, true);
            CanvasBrowser.this.sc.layout(true, true);
            CanvasBrowser.this.updateScroll();
            this.canvasComp.redraw();
            this.canvas.redraw();
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.canvas.forceFocus();
            if (!this.icon.isSelectedCanvas()) {
                CanvasBrowser.this.provider.selectCanvas(this.icon);
                return;
            }
            if (e.getSource() != this.nameLabel) {
                return;
            }
            this.nameText.setText(this.icon.getCanvasName());
            this.nameText.selectAll();
            this.nameStackLayout.topControl = this.nameText;
            this.nameStack.layout(true);
            this.nameText.forceFocus();
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

