/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.views.pallet;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.vtp.desktop.core.Activator;
import org.eclipse.vtp.desktop.views.pallet.PallateProviderManager;
import org.eclipse.vtp.desktop.views.pallet.PalletItem;
import org.eclipse.vtp.desktop.views.pallet.PalletItemObserver;
import org.eclipse.vtp.desktop.views.pallet.PalletItemProvider;
import org.eclipse.vtp.desktop.views.pallet.PalletItemTransfer;

public class Pallet {
    private static final Comparator PALLATE_ITEM_PROVIDER_SORT = new Comparator(){

        public int compare(Object left, Object right) {
            PalletItemProvider leftProvider = (PalletItemProvider)left;
            PalletItemProvider rightProvider = (PalletItemProvider)right;
            int diff = leftProvider.getRanking() - rightProvider.getRanking();
            if (diff == 0) {
                diff = leftProvider.getName().compareTo(rightProvider.getName());
            }
            return diff;
        }
    };
    private static final ViewerSorter PALLATE_ITEM_SORT = new ViewerSorter(){

        public int compare(Viewer viewer, Object left, Object right) {
            PalletItem leftItem = (PalletItem)left;
            PalletItem rightItem = (PalletItem)right;
            return leftItem.getName().compareTo(rightItem.getName());
        }
    };
    private IAdaptable container = null;
    private Map sectionsByProvider = Collections.EMPTY_MAP;
    private FormToolkit toolkit = null;
    private ScrolledForm form = null;

    public void setContainer(IAdaptable container) {
        this.container = container;
    }

    public void createControl(Composite parent) {
        TreeMap<PalletItemProvider, ProviderSection> sectionsByProvider = new TreeMap<PalletItemProvider, ProviderSection>(PALLATE_ITEM_PROVIDER_SORT);
        for (PalletItemProvider provider : PallateProviderManager.getPallateProviders()) {
            int numItems = 0;
            List items = provider.getPalletItems();
            for (PalletItem item : items) {
                if (!item.canBeContainedBy(this.container)) continue;
                ++numItems;
            }
            if (numItems <= 0) continue;
            sectionsByProvider.put(provider, new ProviderSection(provider));
        }
        this.sectionsByProvider = Collections.unmodifiableMap(sectionsByProvider);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        Composite formBody = this.form.getBody();
        formBody.setLayout((Layout)new GridLayout(1, false));
        Iterator i = this.sectionsByProvider.values().iterator();
        while (i.hasNext()) {
            ((ProviderSection)i.next()).initialize().setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    public Control getControl() {
        return this.form;
    }

    public void destroy() {
        Iterator i = this.sectionsByProvider.values().iterator();
        while (i.hasNext()) {
            ((ProviderSection)i.next()).destroy();
        }
        this.form = null;
        this.toolkit.dispose();
        this.toolkit = null;
        this.sectionsByProvider = Collections.EMPTY_MAP;
    }

    private final class ProviderSection
    extends LabelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider,
    IMenuListener,
    DragSourceListener,
    IExpansionListener,
    PalletItemObserver {
        final PalletItemProvider provider;
        Section section = null;
        TableViewer viewer = null;

        ProviderSection(PalletItemProvider provider) {
            this.provider = provider;
        }

        Control initialize() {
            this.section = Pallet.this.toolkit.createSection(Pallet.this.form.getBody(), 256);
            this.section.setText(this.provider.getName());
            this.viewer = new TableViewer(Pallet.this.toolkit.createTable((Composite)this.section, 0));
            this.viewer.setContentProvider((IContentProvider)this);
            this.viewer.setLabelProvider((IBaseLabelProvider)this);
            this.viewer.setSorter(PALLATE_ITEM_SORT);
            this.viewer.setInput((Object)this.provider);
            this.viewer.addDragSupport(3, new Transfer[]{PalletItemTransfer.getInstance()}, (DragSourceListener)this);
            MenuManager menuMgr = new MenuManager("#PopupMenu");
            menuMgr.setRemoveAllWhenShown(true);
            menuMgr.addMenuListener((IMenuListener)this);
            this.viewer.getControl().setMenu(menuMgr.createContextMenu(this.viewer.getControl()));
            this.section.setClient(this.viewer.getControl());
            if (this.equals(Pallet.this.sectionsByProvider.values().iterator().next())) {
                this.section.setExpanded(true);
            }
            this.section.addExpansionListener((IExpansionListener)this);
            this.provider.addPalletItemObserver(this);
            return this.section;
        }

        void destroy() {
            this.provider.removePalletItemObserver(this);
            this.section.removeExpansionListener((IExpansionListener)this);
            this.section = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            LinkedList<PalletItem> palletItems = new LinkedList<PalletItem>();
            PalletItemProvider provider = (PalletItemProvider)inputElement;
            List items = provider.getPalletItems();
            for (PalletItem item : items) {
                System.out.println("getElements() Item: " + item.name);
                if (!item.canBeContainedBy(Pallet.this.container)) continue;
                palletItems.add(item);
            }
            return palletItems.toArray();
        }

        public void dispose() {
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((PalletItem)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image icon = ((PalletItem)element).getIcon();
            if (icon != null) {
                return icon;
            }
            return Activator.getDefault().getImageRegistry().get("ICON_MODULE");
        }

        public void menuAboutToShow(IMenuManager manager) {
            this.provider.createMenu(Pallet.this.container, manager, ((IStructuredSelection)this.viewer.getSelection()).toList().toArray(new PalletItem[0]));
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = true;
            PalletItemTransfer.getInstance().setPalletItem((PalletItem)((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
        }

        public void dragSetData(DragSourceEvent event) {
            if (PalletItemTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = PalletItemTransfer.getInstance().getPalletItem();
            }
        }

        public void dragFinished(DragSourceEvent event) {
        }

        public void expansionStateChanging(ExpansionEvent e) {
            if (!e.getState()) {
                return;
            }
            for (ProviderSection providerSection : Pallet.this.sectionsByProvider.values()) {
                if (providerSection == this || providerSection.section == null) continue;
                providerSection.section.setExpanded(false);
            }
        }

        public void expansionStateChanged(ExpansionEvent e) {
        }

        public void palletItemsChanged() {
            try {
                List items = this.provider.getPalletItems();
                for (PalletItem item : items) {
                    System.out.println("Item: " + item.name);
                }
                System.err.println("Viewer null? " + Boolean.toString(this.viewer == null));
                if (this.viewer != null) {
                    this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ProviderSection.this.viewer.refresh();
                            Pallet.this.form.getBody().layout(true, true);
                            Pallet.this.form.reflow(true);
                        }
                    });
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

