/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.ComponentListener;
import org.eclipse.vtp.desktop.model.core.Model;
import org.eclipse.vtp.framework.util.Guid;

public abstract class Component {
    private String id;
    private Model model;
    List listeners = new ArrayList();
    List propertyListeners = new ArrayList();

    public Component() {
        this.id = Guid.createGUID();
    }

    public Component(String id) {
        this.id = id;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public void addListener(ComponentListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(ComponentListener listener) {
        this.listeners.remove(listener);
    }

    public void addPropertyListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
        this.propertyListeners.add(listener);
    }

    public void removePropertyListener(PropertyChangeListener listener) {
        this.propertyListeners.remove(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        int i = 0;
        while (i < this.propertyListeners.size()) {
            ((PropertyChangeListener)this.propertyListeners.get(i)).propertyChange(event);
            ++i;
        }
    }

    protected void fireChange() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ComponentListener)this.listeners.get(i)).componentChanged(this);
            ++i;
        }
    }

    protected void fireDelete() {
        int i = 0;
        while (i < this.listeners.size()) {
            ((ComponentListener)this.listeners.get(i)).componentDeleted(this);
            ++i;
        }
    }

    protected void delete() {
        this.fireDelete();
    }
}

