/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.Component;
import org.eclipse.vtp.desktop.model.core.ConnectorListener;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.Model;
import org.w3c.dom.NodeList;

public class Connector
extends Component {
    private Element origin;
    private Element destination;
    protected List exitCodes = new ArrayList();
    private List listeners = new ArrayList();

    public Connector(Element origin, Element destination) {
        this.origin = origin;
        this.destination = destination;
        destination.addIncomingConnector(this);
    }

    public Connector(Model model, org.w3c.dom.Element connectorElement) {
        String id = connectorElement.getAttribute("id");
        String originId = connectorElement.getAttribute("origin");
        String destinationId = connectorElement.getAttribute("destination");
        this.setId(id);
        List elements = model.listElements();
        int i = 0;
        while (i < elements.size()) {
            Element element = (Element)elements.get(i);
            if (element.getId().equals(originId)) {
                this.origin = element;
            }
            if (element.getId().equals(destinationId)) {
                this.destination = element;
            }
            ++i;
        }
        if (this.origin == null || this.destination == null) {
            throw new RuntimeException("orphaned connector: id=" + id + " origin=" + originId + " destination=" + destinationId);
        }
        NodeList recordList = connectorElement.getElementsByTagName("record");
        int i2 = 0;
        while (i2 < recordList.getLength()) {
            org.w3c.dom.Element recordElement = (org.w3c.dom.Element)recordList.item(i2);
            String sourceName = recordElement.getAttribute("sourcename");
            recordElement.getAttribute("destinationname");
            this.addExitPoint(this.origin.getConnectorRecord(sourceName));
            ++i2;
        }
        this.destination.addIncomingConnector(this);
    }

    public void writeConfiguration(org.w3c.dom.Element configuration) {
        org.w3c.dom.Element connectorElement = configuration.getOwnerDocument().createElement("connector");
        configuration.appendChild(connectorElement);
        connectorElement.setAttribute("id", this.getId());
        connectorElement.setAttribute("origin", this.origin.getId());
        connectorElement.setAttribute("destination", this.destination.getId());
        for (ConnectorRecord cr : this.exitCodes) {
            org.w3c.dom.Element recordElement = connectorElement.getOwnerDocument().createElement("record");
            connectorElement.appendChild(recordElement);
            recordElement.setAttribute("sourcename", cr.getName());
            recordElement.setAttribute("destinationname", "");
        }
    }

    public void setDestination(Element destination) {
        this.destination = destination;
        this.fireChange();
    }

    public void setOrigin(Element origin) {
        this.origin = origin;
        this.fireChange();
    }

    public void addExitPoint(ConnectorRecord record) {
        if (record != null) {
            record.setConnector(this);
            this.exitCodes.add(record);
            this.fireExitAdded(record);
        }
        this.fireChange();
    }

    public void removeExitPoint(ConnectorRecord record) {
        record.setConnector(null);
        this.exitCodes.remove(record);
        this.fireChange();
        this.fireExitRemoved(record);
    }

    public List getExitCodes() {
        return Collections.unmodifiableList(this.exitCodes);
    }

    public void clearExitCodes() {
        List oldExits = this.exitCodes;
        this.exitCodes = new ArrayList();
        for (ConnectorRecord cr : oldExits) {
            cr.setConnector(null);
            this.fireExitRemoved(cr);
        }
    }

    public Element getDestination() {
        return this.destination;
    }

    public Element getOrigin() {
        return this.origin;
    }

    protected void delete() {
        this.clearExitCodes();
        this.destination.removeIncomingConnector(this);
        super.delete();
    }

    public void addConnectorListener(ConnectorListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeConnectorListener(ConnectorListener listener) {
        this.listeners.remove(listener);
    }

    private void fireExitAdded(ConnectorRecord cr) {
        for (ConnectorListener listener : this.listeners) {
            listener.exitPointAdded(cr);
        }
    }

    private void fireExitRemoved(ConnectorRecord cr) {
        for (ConnectorListener listener : this.listeners) {
            listener.exitPointRemoved(cr);
        }
    }
}

