/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManagerRegistry;
import org.eclipse.vtp.desktop.model.core.Component;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;

public abstract class Element
extends Component {
    public static final String PROP_NAME = "model.element.name";
    private String name;
    private Map configurationManagersByType;
    private List configurationManagers;
    private List incomingConnectors = new ArrayList();
    private boolean hasErrors = false;
    private boolean hasWarnings = false;
    private boolean hasTodo = false;
    private Map configRefs = new HashMap();
    private String scope = "";

    public Element(String name) {
        this.name = name;
        this.configurationManagersByType = new HashMap();
        this.configurationManagers = new ArrayList();
    }

    public Element(String id, String name) {
        super(id);
        this.name = name;
        this.configurationManagersByType = new HashMap();
        this.configurationManagers = new ArrayList();
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange(PROP_NAME, oldName, name);
        this.fireChange();
    }

    public void addConfigurationManager(ConfigurationManager manager) {
        this.configurationManagersByType.put(manager.getType(), manager);
        this.configurationManagers.add(manager);
    }

    public ConfigurationManager getConfigurationManager(String type) {
        ConfigRefCount ref;
        ConfigurationManager cm = (ConfigurationManager)this.configurationManagersByType.get(type);
        if (cm == null) {
            System.out.println(type);
            cm = ConfigurationManagerRegistry.getInstance().getConfigurationManager(type);
            cm.setBrandManager(this.getModel().getBrandManager());
            if (cm != null) {
                System.out.println(cm.getType());
                this.configurationManagers.add(cm);
                this.configurationManagersByType.put(type, cm);
            }
        }
        if ((ref = (ConfigRefCount)this.configRefs.get(type)) == null) {
            ref = new ConfigRefCount();
            ref.configType = type;
            ref.copy = (ConfigurationManager)cm.clone();
            this.configRefs.put(type, ref);
        }
        ConfigRefCount configRefCount = ref;
        configRefCount.refs = configRefCount.refs + 1;
        System.out.println(ref.copy + " ref count: " + ref.refs);
        return ref.copy;
    }

    public void commitConfigurationChanges(ConfigurationManager manager) {
        ConfigRefCount ref = (ConfigRefCount)this.configRefs.get(manager.getType());
        if (ref == null) {
            System.err.println("Big problems!  no ref counter for " + manager);
            return;
        }
        ConfigRefCount configRefCount = ref;
        configRefCount.refs = configRefCount.refs - 1;
        System.out.println(manager + " ref count: " + ref.refs);
        if (ref.refs == 0) {
            this.configRefs.remove(manager.getType());
            ConfigurationManager cm = (ConfigurationManager)this.configurationManagersByType.get(manager.getType());
            this.configurationManagers.remove(cm);
            this.configurationManagers.add(manager);
            this.configurationManagersByType.put(manager.getType(), manager);
        }
    }

    public void rollbackConfigurationChanges(ConfigurationManager manager) {
        this.configRefs.remove(manager.getType());
    }

    public List listConfigurationManagers() {
        return Collections.unmodifiableList(this.configurationManagers);
    }

    public void addIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
        this.incomingConnectors.add(connector);
    }

    public void removeIncomingConnector(Connector connector) {
        this.incomingConnectors.remove(connector);
    }

    public List getIncomingConnectors() {
        return this.incomingConnectors;
    }

    public List getOutgoingVariables(String exitPoint) {
        LinkedHashMap ret = new LinkedHashMap();
        this.getOutgoingVariables(exitPoint, ret, new HashMap());
        return new ArrayList(ret.values());
    }

    public List getIncomingVariables() {
        LinkedHashMap ret = new LinkedHashMap();
        this.getIncomingVariables(ret, new HashMap());
        return new ArrayList(ret.values());
    }

    public void getOutgoingVariables(String exitPoint, Map variables, Map visited) {
        String actionAndExitId = String.valueOf(this.scope.equals("") ? "" : String.valueOf(this.scope) + ":") + this.getId() + ":" + exitPoint;
        if (visited.get(actionAndExitId) == null) {
            visited.put(actionAndExitId, this);
            this.getIncomingVariables(variables, visited);
        }
    }

    public void getIncomingVariables(Map variables, Map visited) {
        for (Connector connector : this.incomingConnectors) {
            Element origin = connector.getOrigin();
            List connectorExits = connector.getExitCodes();
            int e = 0;
            while (e < connectorExits.size()) {
                ConnectorRecord cr = (ConnectorRecord)connectorExits.get(e);
                origin.getOutgoingVariables(cr.getName(), variables, visited);
                ++e;
            }
        }
    }

    public boolean hasPathToStart(Map originPath) {
        if (originPath == null) {
            originPath = new HashMap<String, Element>();
        }
        originPath.put(this.getId(), this);
        boolean ret = false;
        int i = 0;
        while (i < this.incomingConnectors.size()) {
            boolean has;
            Connector connector = (Connector)this.incomingConnectors.get(i);
            if (originPath.get(connector.getOrigin().getId()) == null && (ret |= (has = connector.getOrigin().hasPathToStart(originPath)))) {
                return ret;
            }
            ++i;
        }
        return ret;
    }

    public void resolve() {
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public boolean hasTodo() {
        return this.hasTodo;
    }

    public void validateStatus() {
        this.hasErrors = !this.hasPathToStart(null);
        this.hasWarnings = false;
        this.hasTodo = false;
        for (ConnectorRecord cr : this.getConnectorRecords(ConnectorRecord.EXIT_POINT)) {
            if (cr.getConnector() != null) continue;
            this.hasWarnings = true;
            break;
        }
        for (ConnectorRecord cr : this.getConnectorRecords(ConnectorRecord.ERROR_POINT)) {
            if (cr.getConnector() != null) continue;
            this.hasTodo = true;
            break;
        }
    }

    public abstract void readConfiguration(org.w3c.dom.Element var1);

    public abstract void writeConfiguration(org.w3c.dom.Element var1);

    public abstract boolean acceptConnector(Element var1);

    public abstract boolean hasConnectors();

    public abstract List getConnectorRecords();

    public abstract List getConnectorRecords(int var1);

    public abstract ConnectorRecord getConnectorRecord(String var1);

    public abstract String getTypeName();

    public abstract List getConfigurationPanels();

    public abstract Image getIcon();

    private class ConfigRefCount {
        private String configType;
        private int refs = 0;
        private ConfigurationManager copy;

        private ConfigRefCount() {
        }
    }
}

