/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.ElementReader;
import org.osgi.framework.Bundle;

public class ElementManager {
    public static final String elementTypeExtensionId = "org.eclipse.vtp.desktop.model.core.elementType";
    private static final ElementManager INSTANCE = new ElementManager();
    private Map elementTypes = new HashMap();

    public static ElementManager getInstance() {
        return INSTANCE;
    }

    public ElementManager() {
        IConfigurationElement[] primitiveExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(elementTypeExtensionId);
        int i = 0;
        while (i < primitiveExtensions.length) {
            block3: {
                ReaderRecord rr = new ReaderRecord();
                rr.tag = primitiveExtensions[i].getAttribute("xml-element");
                rr.namespace = primitiveExtensions[i].getAttribute("xml-namespace");
                String className = primitiveExtensions[i].getAttribute("class");
                Bundle contributor = Platform.getBundle((String)primitiveExtensions[i].getContributor().getName());
                try {
                    rr.reader = contributor.loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    break block3;
                }
                this.elementTypes.put(String.valueOf(rr.namespace) + "/" + rr.tag, rr);
            }
            ++i;
        }
    }

    public Element loadElement(org.w3c.dom.Element elementElement) {
        ReaderRecord rr = (ReaderRecord)this.elementTypes.get(String.valueOf(elementElement.getNamespaceURI() == null ? "" : elementElement.getNamespaceURI()) + "/" + elementElement.getTagName());
        try {
            ElementReader er = (ElementReader)rr.reader.newInstance();
            return er.readElement(elementElement);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class ReaderRecord {
        String tag;
        String namespace;
        Class reader;

        private ReaderRecord() {
        }
    }
}

