/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManager;
import org.eclipse.vtp.desktop.core.configuration.ConfigurationManagerRegistry;
import org.eclipse.vtp.desktop.model.core.Component;
import org.eclipse.vtp.desktop.model.core.ComponentListener;
import org.eclipse.vtp.desktop.model.core.Connector;
import org.eclipse.vtp.desktop.model.core.ConnectorRecord;
import org.eclipse.vtp.desktop.model.core.Element;
import org.eclipse.vtp.desktop.model.core.ElementManager;
import org.eclipse.vtp.desktop.model.core.ElementResolutionVisitor;
import org.eclipse.vtp.desktop.model.core.ModelListener;
import org.w3c.dom.NodeList;

public class Model
implements ComponentListener {
    private BrandManager brandManager;
    private List elements = new ArrayList();
    private List connectors = new ArrayList();
    private List listeners = new ArrayList();
    private Map dataServices = new HashMap();

    public Model(BrandManager brandManager) {
        this.brandManager = brandManager;
    }

    public Model(BrandManager brandManager, org.w3c.dom.Element modelElement, ElementResolutionVisitor resolutionVisitor) {
        this(brandManager);
        NodeList elementElementList = modelElement.getElementsByTagName("elements");
        if (elementElementList.getLength() > 0) {
            NodeList elementList = ((org.w3c.dom.Element)elementElementList.item(0)).getChildNodes();
            int i = 0;
            while (i < elementList.getLength()) {
                if (elementList.item(i).getNodeType() == 1) {
                    org.w3c.dom.Element elementElement = (org.w3c.dom.Element)elementList.item(i);
                    Element element = null;
                    org.w3c.dom.Element customConfigElement = null;
                    element = ElementManager.getInstance().loadElement(elementElement);
                    if (element != null) {
                        this.addElement(element);
                        NodeList configSectionList = elementElement.getChildNodes();
                        int c = 0;
                        while (c < configSectionList.getLength()) {
                            if (configSectionList.item(c).getNodeType() == 1) {
                                org.w3c.dom.Element configSectionElement = (org.w3c.dom.Element)configSectionList.item(c);
                                if (configSectionElement.getNodeName().equals("custom-config") && configSectionElement.getNamespaceURI() != null && configSectionElement.getNamespaceURI().equals("http://www.eclipse.org/vtp/namespaces/config")) {
                                    customConfigElement = configSectionElement;
                                } else {
                                    ConfigurationManager manager = ConfigurationManagerRegistry.getInstance().getConfigurationManager(configSectionElement.getNamespaceURI(), configSectionElement.getNodeName());
                                    manager.setBrandManager(brandManager);
                                    manager.readConfiguration(configSectionElement);
                                    element.addConfigurationManager(manager);
                                }
                            }
                            ++c;
                        }
                        element.readConfiguration(customConfigElement);
                    }
                }
                ++i;
            }
        }
        for (Element element : this.elements) {
            element.resolve();
            if (resolutionVisitor == null) continue;
            resolutionVisitor.resolveElement(element);
        }
        NodeList connectorElementList = modelElement.getElementsByTagName("connectors");
        if (connectorElementList.getLength() > 0) {
            NodeList connectorList = ((org.w3c.dom.Element)connectorElementList.item(0)).getElementsByTagName("connector");
            int i = 0;
            while (i < connectorList.getLength()) {
                org.w3c.dom.Element connectorElement = (org.w3c.dom.Element)connectorList.item(i);
                this.addConnector(new Connector(this, connectorElement));
                ++i;
            }
        }
    }

    public Object getDataService(String name) {
        return this.dataServices.get(name);
    }

    public void putDataService(String name, Object service) {
        this.dataServices.put(name, service);
    }

    public void storeModel(org.w3c.dom.Element rootElement) {
        org.w3c.dom.Element modelElement = rootElement.getOwnerDocument().createElement("model");
        rootElement.appendChild(modelElement);
        org.w3c.dom.Element elementsElement = modelElement.getOwnerDocument().createElement("elements");
        modelElement.appendChild(elementsElement);
        int i = 0;
        while (i < this.elements.size()) {
            Element el = (Element)this.elements.get(i);
            el.writeConfiguration(elementsElement);
            ++i;
        }
        org.w3c.dom.Element connectorsElement = modelElement.getOwnerDocument().createElement("connectors");
        modelElement.appendChild(connectorsElement);
        int i2 = 0;
        while (i2 < this.connectors.size()) {
            Connector cn = (Connector)this.connectors.get(i2);
            cn.writeConfiguration(connectorsElement);
            ++i2;
        }
    }

    public List listElements() {
        return Collections.unmodifiableList(this.elements);
    }

    public List listConnectors() {
        return Collections.unmodifiableList(this.connectors);
    }

    public Element getElement(String id) {
        int i = 0;
        while (i < this.elements.size()) {
            Element e = (Element)this.elements.get(i);
            if (e.getId().equals(id)) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public void validateModelStatus() {
        for (Element element : this.elements) {
            element.validateStatus();
        }
    }

    public Connector getConnector(String id) {
        int i = 0;
        while (i < this.connectors.size()) {
            Connector c = (Connector)this.connectors.get(i);
            if (c.getId().equals(id)) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public void removeElement(Element element) {
        List conrecs = element.getConnectorRecords();
        int i = 0;
        while (i < conrecs.size()) {
            ConnectorRecord cr = (ConnectorRecord)conrecs.get(i);
            if (cr.getConnector() != null) {
                this.deleteComponent(cr.getConnector());
            }
            ++i;
        }
        LinkedList inc = new LinkedList();
        inc.addAll(element.getIncomingConnectors());
        int i2 = 0;
        while (i2 < inc.size()) {
            Connector con = (Connector)inc.get(i2);
            this.deleteComponent(con);
            ++i2;
        }
        this.deleteComponent(element);
    }

    public void removeConnector(Connector connector) {
        this.deleteComponent(connector);
    }

    private void deleteComponent(Component connector) {
        connector.delete();
    }

    public void addElement(Element element) {
        this.elements.remove(element);
        this.elements.add(element);
        element.setModel(this);
        element.addListener(this);
        element.resolve();
        this.fireComponentAdded(element);
    }

    public void addConnector(Connector connector) {
        this.connectors.remove(connector);
        this.connectors.add(connector);
        connector.setModel(this);
        connector.addListener(this);
        this.fireComponentAdded(connector);
    }

    public void componentChanged(Component component) {
    }

    public BrandManager getBrandManager() {
        return this.brandManager;
    }

    public void componentDeleted(Component component) {
        System.out.println("deleting: " + component);
        if (component instanceof Connector) {
            this.connectors.remove(component);
        } else {
            this.elements.remove(component);
        }
        this.fireComponentRemoved(component);
    }

    public void addListener(ModelListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(ModelListener listener) {
        this.listeners.remove(listener);
    }

    private void fireComponentAdded(Component component) {
        for (ModelListener listener : this.listeners) {
            listener.componentAdded(this, component);
        }
    }

    private void fireComponentRemoved(Component component) {
        for (ModelListener listener : this.listeners) {
            listener.componentRemoved(this, component);
        }
    }
}

