/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vtp.desktop.model.core.ObjectField;
import org.eclipse.vtp.desktop.projects.core.FieldType;

public class ObjectDefinition {
    String name;
    FieldType type;
    List fields;
    boolean hasValue;
    String defaultValue;

    public ObjectDefinition(String name, FieldType type) {
        this.name = name;
        this.type = type;
        this.hasValue = (type.getTypeName().equals("String") || type.getTypeName().equals("Number") || type.getTypeName().equals("Decimal") || type.getTypeName().equals("Boolean") || type.getTypeName().equals("DateTime")) && !type.isArray();
        this.fields = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public FieldType getType() {
        return this.type;
    }

    public List getFields() {
        return this.fields;
    }

    public String getPath() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectDefinition) {
            ObjectDefinition od = (ObjectDefinition)obj;
            return od.getPath().equals(this.getPath());
        }
        return false;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public ObjectField addField(ObjectField field) {
        this.fields.add(field);
        field.setParent(this);
        return field;
    }
}

