/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.configuration;

import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.core.dialogs.ContentPage;
import org.eclipse.vtp.desktop.core.dialogs.MultiPageFramedDialog;
import org.eclipse.vtp.desktop.model.core.configuration.ComponentPropertiesPanel;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationContextSelector;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationContextSelectorListener;

public class ComponentPropertiesDialog
extends MultiPageFramedDialog
implements ConfigurationContextSelectorListener {
    BrandManager brandManager;

    public ComponentPropertiesDialog(BrandManager brandManager, Shell parentShell) {
        super(parentShell);
        this.setSideBarSize(120);
        this.brandManager = brandManager;
    }

    protected boolean processOk() {
        try {
            List pages = this.getPages();
            Iterator iterator = pages.iterator();
            while (iterator.hasNext()) {
                ((ComponentPropertiesPanel)((Object)iterator.next())).save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected void cancelPressed() {
        try {
            List pages = this.getPages();
            Iterator iterator = pages.iterator();
            while (iterator.hasNext()) {
                ((ComponentPropertiesPanel)((Object)iterator.next())).cancel();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.cancelPressed();
    }

    protected void handleShellCloseEvent() {
        try {
            List pages = this.getPages();
            Iterator iterator = pages.iterator();
            while (iterator.hasNext()) {
                ((ComponentPropertiesPanel)((Object)iterator.next())).save();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.handleShellCloseEvent();
    }

    protected void createDialogContents(Composite parent) {
        System.out.println("in create dialog contents");
        try {
            parent.setLayout((Layout)new GridLayout(1, false));
            Composite topComp = new Composite(parent, 0);
            topComp.setBackground(parent.getBackground());
            topComp.setLayout((Layout)new FillLayout());
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 0x1000000;
            topComp.setLayoutData((Object)gridData);
            ConfigurationContextSelector selector = new ConfigurationContextSelector(this.brandManager);
            selector.addListener(this);
            selector.createControls(topComp);
            Composite bottomComp = new Composite(parent, 0);
            bottomComp.setBackground(parent.getBackground());
            bottomComp.setLayout((Layout)new FillLayout());
            bottomComp.setLayoutData((Object)new GridData(1808));
            Composite c = new Composite(bottomComp, 0);
            c.setBackground(bottomComp.getBackground());
            super.createDialogContents(c);
            this.contextSelectionChanged(selector.getCurrentBrand(), selector.getCurrentInteractionType(), selector.getCurrentLanguage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void contextSelectionChanged(Brand brand, String interactionType, String language) {
        List pages = this.getPages();
        Iterator iterator = pages.iterator();
        while (iterator.hasNext()) {
            ((ComponentPropertiesPanel)((Object)iterator.next())).setConfigurationContext(brand, interactionType, language);
        }
    }

    public void addPage(ContentPage page) {
        if (page instanceof ComponentPropertiesPanel) {
            ((ComponentPropertiesPanel)page).setContainer(this);
        }
        super.addPage(page);
    }
}

