/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.desktop.model.core.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.vtp.desktop.core.InteractionType;
import org.eclipse.vtp.desktop.core.InteractionTypeManager;
import org.eclipse.vtp.desktop.core.configuration.Brand;
import org.eclipse.vtp.desktop.core.configuration.BrandManager;
import org.eclipse.vtp.desktop.model.core.configuration.ConfigurationContextSelectorListener;

public class ConfigurationContextSelector {
    private BrandManager brandManager;
    private Brand selectedBrand;
    private String selectedInteractionType;
    private String selectedLanguage;
    private List flatBrandList = new ArrayList();
    private List interactionTypes;
    private List languages;
    private List listeners = new ArrayList();
    private Combo brandCombo;
    private Combo interactionCombo;
    private Combo languageCombo;

    public ConfigurationContextSelector(BrandManager brandManager) {
        this.brandManager = brandManager;
    }

    public Control createControls(Composite parent) {
        this.interactionTypes = this.brandManager.getSupportedInteractionTypes();
        Composite comp = new Composite(parent, 0);
        comp.setBackground(parent.getBackground());
        comp.setLayout((Layout)new GridLayout(6, false));
        Label brandLabel = new Label(comp, 0);
        brandLabel.setBackground(comp.getBackground());
        brandLabel.setText("Brand:");
        brandLabel.setLayoutData((Object)new GridData());
        this.brandCombo = new Combo(comp, 12);
        this.brandCombo.setLayoutData((Object)new GridData());
        this.addBrand(this.brandManager.getDefaultBrand(), this.brandCombo, 0);
        this.brandCombo.select(0);
        this.selectedBrand = this.brandManager.getDefaultBrand();
        this.brandCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConfigurationContextSelector.this.selectedBrand = (Brand)ConfigurationContextSelector.this.flatBrandList.get(ConfigurationContextSelector.this.brandCombo.getSelectionIndex());
                ConfigurationContextSelector.this.fireSelectionChanged();
            }
        });
        Label interactionLabel = new Label(comp, 0);
        interactionLabel.setBackground(comp.getBackground());
        interactionLabel.setText("Interaction:");
        interactionLabel.setLayoutData((Object)new GridData());
        this.interactionCombo = new Combo(comp, 12);
        this.interactionCombo.setLayoutData((Object)new GridData());
        int i = 0;
        while (i < this.interactionTypes.size()) {
            String interactionType = (String)this.interactionTypes.get(i);
            System.out.println("interaction type: " + interactionType);
            InteractionType it = InteractionTypeManager.getInstance().getType(interactionType);
            this.interactionCombo.add(it.getName());
            ++i;
        }
        this.interactionCombo.select(0);
        this.selectedInteractionType = (String)this.interactionTypes.get(0);
        this.interactionCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConfigurationContextSelector.this.selectedInteractionType = (String)ConfigurationContextSelector.this.interactionTypes.get(ConfigurationContextSelector.this.interactionCombo.getSelectionIndex());
                ConfigurationContextSelector.this.languages = ConfigurationContextSelector.this.brandManager.getSupportedLanguages(ConfigurationContextSelector.this.selectedInteractionType);
                ConfigurationContextSelector.this.languageCombo.removeAll();
                int i = 0;
                while (i < ConfigurationContextSelector.this.languages.size()) {
                    String language = (String)ConfigurationContextSelector.this.languages.get(i);
                    ConfigurationContextSelector.this.languageCombo.add(language);
                    ++i;
                }
                ConfigurationContextSelector.this.languageCombo.select(0);
                ConfigurationContextSelector.this.selectedLanguage = (String)ConfigurationContextSelector.this.languages.get(0);
                ConfigurationContextSelector.this.fireSelectionChanged();
            }
        });
        Label languageLabel = new Label(comp, 0);
        languageLabel.setBackground(comp.getBackground());
        languageLabel.setText("Language:");
        languageLabel.setLayoutData((Object)new GridData());
        this.languageCombo = new Combo(comp, 12);
        this.languageCombo.setLayoutData((Object)new GridData());
        this.languages = this.brandManager.getSupportedLanguages((String)this.interactionTypes.get(0));
        int i2 = 0;
        while (i2 < this.languages.size()) {
            String language = (String)this.languages.get(i2);
            this.languageCombo.add(language);
            ++i2;
        }
        this.languageCombo.select(0);
        this.selectedLanguage = (String)this.languages.get(0);
        this.languageCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ConfigurationContextSelector.this.selectedLanguage = (String)ConfigurationContextSelector.this.languages.get(ConfigurationContextSelector.this.languageCombo.getSelectionIndex());
                ConfigurationContextSelector.this.fireSelectionChanged();
            }
        });
        return comp;
    }

    public Brand getCurrentBrand() {
        return this.selectedBrand;
    }

    public String getCurrentInteractionType() {
        return this.selectedInteractionType;
    }

    public String getCurrentLanguage() {
        return this.selectedLanguage;
    }

    public void addListener(ConfigurationContextSelectorListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeListener(ConfigurationContextSelectorListener listener) {
        this.listeners.remove(listener);
    }

    public void setBrandEnabled(boolean enabled) {
        this.brandCombo.setVisible(enabled);
    }

    public void setInteractionTypeEnabled(boolean enabled) {
        this.interactionCombo.setVisible(enabled);
    }

    public void setLanguageEnabled(boolean enabled) {
        this.languageCombo.setVisible(enabled);
    }

    private String spacer(int size) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < size) {
            buf.append(" ");
            ++i;
        }
        return buf.toString();
    }

    private void addBrand(Brand brand, Combo combo, int indent) {
        combo.add(String.valueOf(this.spacer(indent * 2)) + brand.getName());
        this.flatBrandList.add(brand);
        List children = brand.getChildBrands();
        int i = 0;
        while (i < children.size()) {
            Brand child = (Brand)children.get(i);
            this.addBrand(child, combo, indent + 1);
            ++i;
        }
    }

    private void fireSelectionChanged() {
        for (ConfigurationContextSelectorListener l : this.listeners) {
            l.contextSelectionChanged(this.getCurrentBrand(), this.getCurrentInteractionType(), this.getCurrentLanguage());
        }
    }
}

