/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.BridgeMessageConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;

public class BridgeMessageAction
implements IAction {
    private final IActionContext context;
    private final IConversation conversation;
    private final BridgeMessageConfiguration configuration;

    public BridgeMessageAction(IActionContext context, IConversation conversation, BridgeMessageConfiguration configuration) {
        this.context = context;
        this.conversation = conversation;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        try {
            Hashtable<String, Object> props;
            this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            String result = this.context.getParameter(this.context.getActionID());
            if (result != null) {
                props = new Hashtable<String, Object>();
                ((Dictionary)props).put("event", "bridge.after");
                ((Dictionary)props).put("bridge.destination", this.configuration.getDestination());
                this.context.report(3, "Ended bridge with destination \"" + this.configuration.getDestination() + "\"", props);
                if ("transferred".equals(result)) {
                    return this.context.createResult("Call Transfered");
                }
                if ("busy".equals(result)) {
                    return this.context.createResult("Line Busy");
                }
                if ("unavailable".equals(result)) {
                    return this.context.createResult("No Answer");
                }
                if ("noauthorization".equals(result)) {
                    return this.context.createResult("error.connection.noauthorization");
                }
                if ("baddestination".equals(result)) {
                    return this.context.createResult("error.connection.baddestination");
                }
                if ("noroute".equals(result)) {
                    return this.context.createResult("error.connection.noroute");
                }
                if ("noresource".equals(result)) {
                    return this.context.createResult("error.connection.noresource");
                }
                if ("protocol".equals(result)) {
                    return this.context.createResult("error.connection.protocol");
                }
                if ("badbridge".equals(result)) {
                    return this.context.createResult("error.unsupported.transfer.bridge");
                }
                if ("baduri".equals(result)) {
                    return this.context.createResult("error.unsupported.uri");
                }
            }
            props = new Hashtable();
            ((Dictionary)props).put("event", "bridge.before");
            ((Dictionary)props).put("bridge.destination", this.configuration.getDestination());
            this.context.report(3, "Bridging with destination \"" + this.configuration.getDestination() + "\"", props);
            this.conversation.createBridgeMessage(this.configuration, this.context.getActionID()).enqueue();
            return this.context.createResult("repeat");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.bridge.message", (Throwable)e);
        }
    }
}

