/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vtp.framework.interactions.core.actions;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.vtp.framework.common.IDataObject;
import org.eclipse.vtp.framework.common.IStringObject;
import org.eclipse.vtp.framework.common.IVariableRegistry;
import org.eclipse.vtp.framework.core.IAction;
import org.eclipse.vtp.framework.core.IActionContext;
import org.eclipse.vtp.framework.core.IActionResult;
import org.eclipse.vtp.framework.interactions.core.configurations.DataRequestConfiguration;
import org.eclipse.vtp.framework.interactions.core.conversation.IConversation;

public class DataRequestAction
implements IAction {
    private final IActionContext context;
    private final IVariableRegistry variableRegistry;
    private final IConversation conversation;
    private final DataRequestConfiguration configuration;

    public DataRequestAction(IActionContext context, IVariableRegistry variableRegistry, IConversation conversation, DataRequestConfiguration configuration) {
        this.context = context;
        this.variableRegistry = variableRegistry;
        this.conversation = conversation;
        this.configuration = configuration;
    }

    public IActionResult execute() {
        try {
            this.context.debug(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1));
            String result = this.context.getParameter("rec" + this.context.getActionID());
            if ("success.filled".equals(result)) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "data.request.filled");
                this.context.report(3, "Got requested data \"" + this.context.getParameter(this.configuration.getDataName()) + "\"", props);
                IStringObject variable = (IStringObject)this.variableRegistry.createVariable("String");
                variable.setValue((Object)this.context.getParameter(this.configuration.getDataName()));
                this.variableRegistry.setVariable(this.configuration.getDataName(), (IDataObject)variable);
                return this.context.createResult("default");
            }
            if ("error.input.noinput".equals(result)) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "data.request.noinput");
                this.context.report(3, "Got no input for requested data.", props);
                return this.context.createResult("error.input.noinput");
            }
            if ("error.input.nomatch".equals(result)) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("event", "data.request.nomatch");
                this.context.report(3, "Got no match for requested data.", props);
                return this.context.createResult("error.input.nomatch");
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event", "data.request.before");
            this.context.report(3, "Requesting data \"" + this.configuration.getDataName() + "\".", props);
            this.conversation.createDataRequest(this.configuration, "rec" + this.context.getActionID()).enqueue();
            return this.context.createResult("repeat");
        }
        catch (RuntimeException e) {
            return this.context.createResult("error.data.request", (Throwable)e);
        }
    }
}

